/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.pentamana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.hederamc.pentamana.data.PentamanaConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class ManaCommand {
    public static final SimpleCommandExceptionType REQUIRES_LIVING_ENTITY_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"A living entity is required to run this command here"));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mana").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> ManaCommand.executeGet((class_2168)context.getSource()))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> ManaCommand.executeGet((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ManaCommand.executeSet((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ManaCommand.executeAdd((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))))).then(class_2170.method_9247((String)"subtract").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ManaCommand.executeSubtract((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount")))))));
    }

    public static int executeGet(class_2168 source) throws CommandSyntaxException {
        return ManaCommand.executeGet(source, source.method_9229());
    }

    public static int executeGet(class_2168 source, class_1297 entity) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw REQUIRES_LIVING_ENTITY_EXCEPTION.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        float supply = livingEntity.getMana();
        source.method_9226(() -> class_2561.method_43470((String)(livingEntity.method_5820() + " has " + supply + " mana.")), false);
        return (int)(supply / (float)PentamanaConfig.manaPerPoint);
    }

    public static int executeSet(class_2168 source, class_1297 entity, float amount) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw REQUIRES_LIVING_ENTITY_EXCEPTION.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        livingEntity.setMana(amount);
        source.method_9226(() -> class_2561.method_43470((String)"Set mana for entity ").method_10852(livingEntity.method_5476()).method_27693(" to " + amount + "."), false);
        return (int)(amount / (float)PentamanaConfig.manaPerPoint);
    }

    public static int executeAdd(class_2168 source, class_1297 entity, float amount) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw REQUIRES_LIVING_ENTITY_EXCEPTION.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        float targetSupply = livingEntity.getMana() + amount;
        livingEntity.setMana(targetSupply);
        source.method_9226(() -> class_2561.method_43470((String)("Added " + amount + " mana for entity ")).method_10852(livingEntity.method_5476()).method_27693("."), false);
        return (int)(targetSupply / (float)PentamanaConfig.manaPerPoint);
    }

    public static int executeSubtract(class_2168 source, class_1297 entity, float amount) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw REQUIRES_LIVING_ENTITY_EXCEPTION.create();
        }
        class_1309 livingEntity = (class_1309)entity;
        float targetSupply = livingEntity.getMana() - amount;
        livingEntity.setMana(targetSupply);
        source.method_9226(() -> class_2561.method_43470((String)("Subtracted " + amount + " mana for entity ")).method_10852(livingEntity.method_5476()).method_27693("."), false);
        return (int)(targetSupply / (float)PentamanaConfig.manaPerPoint);
    }
}

