/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.pentamana.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.hederamc.cw.util.BossBars;
import net.hederamc.pentamana.render.ManaBar;
import net.hederamc.pentamana.render.ManaCharset;
import net.hederamc.pentamana.render.ManaPattern;
import net.hederamc.pentamana.render.ManaRender;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_8824;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class PentamanaConfig {
    public static final int MANA_PER_POINT = 1;
    public static final float MANA_CAPACITY_BASE = 2.0f;
    public static final float MANA_REGENERATION_BASE = 0.0625f;
    public static final float ENCHANTMENT_CAPACITY_BASE = 2.0f;
    public static final float ENCHANTMENT_STREAM_BASE = 0.015625f;
    public static final float ENCHANTMENT_MANA_EFFICIENCY_BASE = 0.1f;
    public static final float ENCHANTMENT_POTENCY_BASE = 0.5f;
    public static final float STATUS_EFFECT_MANA_BOOST_BASE = 4.0f;
    public static final float STATUS_EFFECT_MANA_REDUCTION_BASE = 4.0f;
    public static final float STATUS_EFFECT_INSTANT_MANA_BASE = 4.0f;
    public static final float STATUS_EFFECT_INSTANT_DEPLETE_BASE = 6.0f;
    public static final float STATUS_EFFECT_MANA_POWER_BASE = 3.0f;
    public static final float STATUS_EFFECT_MANA_SICKNESS_BASE = 4.0f;
    public static final int STATUS_EFFECT_MANA_REGENERATION_BASE = 50;
    public static final int STATUS_EFFECT_MANA_INHIBITION_BASE = 40;
    public static final boolean SHOULD_CONVERT_EXPERIENCE_LEVEL = false;
    public static final float EXPERIENCE_LEVEL_CONVERSION_BASE = 0.5f;
    public static int manaPerPoint;
    public static float manaCapacityBase;
    public static float manaRegenerationBase;
    public static float enchantmentCapacityBase;
    public static float enchantmentStreamBase;
    public static float enchantmentManaEfficiencyBase;
    public static float enchantmentPotencyBase;
    public static float statusEffectManaBoostBase;
    public static float statusEffectManaReductionBase;
    public static float statusEffectInstantManaBase;
    public static float statusEffectInstantDepleteBase;
    public static float statusEffectManaPowerBase;
    public static float statusEffectManaSicknessBase;
    public static int statusEffectManaRegenerationBase;
    public static int statusEffectManaInhibitionBase;
    public static boolean shouldConvertExperienceLevel;
    public static float experienceLevelConversionBase;
    public static int manaPointLimit;

    public static int reload() {
        String configString;
        try {
            configString = FileUtils.readFileToString((File)new File("./config/pentamana.json"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            PentamanaConfig.reset();
            PentamanaConfig.reCalc();
            return 1;
        }
        JsonObject config = (JsonObject)new Gson().fromJson(configString, JsonObject.class);
        if (config == null) {
            PentamanaConfig.reset();
            PentamanaConfig.reCalc();
            return 1;
        }
        return PentamanaConfig.reload(config);
    }

    public static int reload(JsonObject config) {
        MutableInt counter = new MutableInt(0);
        if (config.has("manaPerPoint")) {
            manaPerPoint = config.get("manaPerPoint").getAsInt();
            counter.increment();
        } else {
            manaPerPoint = 1;
        }
        if (config.has("manaCapacityBase")) {
            manaCapacityBase = config.get("manaCapacityBase").getAsFloat();
            counter.increment();
        } else {
            manaCapacityBase = 2.0f;
        }
        if (config.has("manaRegenerationBase")) {
            manaRegenerationBase = config.get("manaRegenerationBase").getAsFloat();
            counter.increment();
        } else {
            manaRegenerationBase = 0.0625f;
        }
        if (config.has("enchantmentCapacityBase")) {
            enchantmentCapacityBase = config.get("enchantmentCapacityBase").getAsFloat();
            counter.increment();
        } else {
            enchantmentCapacityBase = 2.0f;
        }
        if (config.has("enchantmentStreamBase")) {
            enchantmentStreamBase = config.get("enchantmentStreamBase").getAsFloat();
            counter.increment();
        } else {
            enchantmentStreamBase = 0.015625f;
        }
        if (config.has("enchantmentManaEfficiencyBase")) {
            enchantmentManaEfficiencyBase = config.get("enchantmentManaEfficiencyBase").getAsFloat();
            counter.increment();
        } else {
            enchantmentManaEfficiencyBase = 0.1f;
        }
        if (config.has("enchantmentPotencyBase")) {
            enchantmentPotencyBase = config.get("enchantmentPotencyBase").getAsFloat();
            counter.increment();
        } else {
            enchantmentPotencyBase = 0.5f;
        }
        if (config.has("statusEffectManaBoostBase")) {
            statusEffectManaBoostBase = config.get("statusEffectManaBoostBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectManaBoostBase = 4.0f;
        }
        if (config.has("statusEffectManaReductionBase")) {
            statusEffectManaReductionBase = config.get("statusEffectManaReductionBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectManaReductionBase = 4.0f;
        }
        if (config.has("statusEffectInstantManaBase")) {
            statusEffectInstantManaBase = config.get("statusEffectInstantManaBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectInstantManaBase = 4.0f;
        }
        if (config.has("statusEffectInstantDepleteBase")) {
            statusEffectInstantDepleteBase = config.get("statusEffectInstantDepleteBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectInstantDepleteBase = 6.0f;
        }
        if (config.has("statusEffectManaPowerBase")) {
            statusEffectManaPowerBase = config.get("statusEffectManaPowerBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectManaPowerBase = 3.0f;
        }
        if (config.has("statusEffectManaSicknessBase")) {
            statusEffectManaSicknessBase = config.get("statusEffectManaSicknessBase").getAsFloat();
            counter.increment();
        } else {
            statusEffectManaSicknessBase = 4.0f;
        }
        if (config.has("statusEffectManaRegenerationBase")) {
            statusEffectManaRegenerationBase = config.get("statusEffectManaRegenerationBase").getAsInt();
            counter.increment();
        } else {
            statusEffectManaRegenerationBase = 50;
        }
        if (config.has("statusEffectManaInhibitionBase")) {
            statusEffectManaInhibitionBase = config.get("statusEffectManaInhibitionBase").getAsInt();
            counter.increment();
        } else {
            statusEffectManaInhibitionBase = 40;
        }
        if (config.has("shouldConvertExperienceLevel")) {
            shouldConvertExperienceLevel = config.get("shouldConvertExperienceLevel").getAsBoolean();
            counter.increment();
        } else {
            shouldConvertExperienceLevel = false;
        }
        if (config.has("experienceLevelConversionBase")) {
            experienceLevelConversionBase = config.get("experienceLevelConversionBase").getAsFloat();
            counter.increment();
        } else {
            experienceLevelConversionBase = 0.5f;
        }
        if (config.has("default_preference")) {
            JsonObject defaultPreference = config.get("default_preference").getAsJsonObject();
            counter.add(DefaultPreference.reload(defaultPreference));
        } else {
            DefaultPreference.reset();
        }
        PentamanaConfig.reCalc();
        return counter.intValue();
    }

    public static void reset() {
        manaPerPoint = 1;
        manaCapacityBase = 2.0f;
        manaRegenerationBase = 0.0625f;
        enchantmentCapacityBase = 2.0f;
        enchantmentStreamBase = 0.015625f;
        enchantmentManaEfficiencyBase = 0.1f;
        enchantmentPotencyBase = 0.5f;
        statusEffectManaBoostBase = 4.0f;
        statusEffectManaReductionBase = 4.0f;
        statusEffectInstantManaBase = 4.0f;
        statusEffectInstantDepleteBase = 6.0f;
        statusEffectManaRegenerationBase = 50;
        statusEffectManaInhibitionBase = 40;
        statusEffectManaPowerBase = 3.0f;
        statusEffectManaSicknessBase = 4.0f;
        shouldConvertExperienceLevel = false;
        experienceLevelConversionBase = 0.5f;
        DefaultPreference.reset();
    }

    public static void reCalc() {
        manaPointLimit = 127 * manaPerPoint;
    }

    public abstract class DefaultPreference {
        public static final boolean IS_VISIBLE = true;
        public static final boolean IS_SUPPRESSED = false;
        public static final ManaBar.Position POSITION = ManaBar.Position.ACTIONBAR;
        public static final ManaPattern PATTERN = new ManaPattern(Stream.of(class_2561.method_43470((String)"$")).collect(Collectors.toList()));
        public static final ManaRender.Type TYPE = ManaRender.Type.CHARACTER;
        public static final ManaCharset CHARSET = new ManaCharset(Stream.concat(Stream.of(Collections.nCopies(128, class_2561.method_43470((String)"\u2605").method_27692(class_124.field_1075)), Collections.nCopies(128, class_2561.method_43470((String)"\u2bea").method_27692(class_124.field_1075)), Collections.nCopies(128, class_2561.method_43470((String)"\u2606").method_27692(class_124.field_1074))), Collections.nCopies(125, Collections.nCopies(128, class_2561.method_43470((String)"\ufffd"))).stream()).map(ArrayList::new).collect(Collectors.toList()));
        public static final int POINTS_PER_CHARACTER = 2;
        public static final boolean IS_COMPRESSED = false;
        public static final byte COMPRESSION_SIZE = 20;
        public static final class_1259.class_1260 COLOR = class_1259.class_1260.field_5780;
        public static final class_1259.class_1261 STYLE = class_1259.class_1261.field_5795;
        public static boolean isVisible;
        public static boolean isSuppressed;
        public static ManaBar.Position position;
        public static ManaRender.Type type;
        public static ManaPattern pattern;
        public static int pointsPerCharacter;
        public static boolean isCompressed;
        public static byte compressionSize;
        public static ManaCharset charset;
        public static class_1259.class_1260 color;
        public static class_1259.class_1261 style;

        public DefaultPreference(PentamanaConfig this$0) {
        }

        public static int reload() {
            String configString;
            try {
                configString = FileUtils.readFileToString((File)new File("./config/pentamana.json"), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                DefaultPreference.reset();
                return 1;
            }
            JsonObject config = (JsonObject)new Gson().fromJson(configString, JsonObject.class);
            if (config == null || !config.has("default_preference")) {
                DefaultPreference.reset();
                return 1;
            }
            JsonObject defaultPreference = config.get("default_preference").getAsJsonObject();
            if (defaultPreference == null) {
                DefaultPreference.reset();
                return 1;
            }
            return DefaultPreference.reload(defaultPreference);
        }

        public static int reload(JsonObject defaultPreference) {
            MutableInt counter = new MutableInt(0);
            if (defaultPreference.has("isVisible")) {
                isVisible = defaultPreference.get("isVisible").getAsBoolean();
                counter.increment();
            } else {
                isVisible = true;
            }
            if (defaultPreference.has("isSuppressed")) {
                isSuppressed = defaultPreference.get("isSuppressed").getAsBoolean();
                counter.increment();
            } else {
                isSuppressed = true;
            }
            if (defaultPreference.has("position")) {
                position = ManaBar.Position.byName(defaultPreference.get("position").getAsString());
                counter.increment();
            } else {
                position = POSITION;
            }
            if (defaultPreference.has("type")) {
                type = ManaRender.Type.byName(defaultPreference.get("type").getAsString());
                counter.increment();
            } else {
                type = TYPE;
            }
            if (defaultPreference.has("pattern")) {
                pattern = new ManaPattern(defaultPreference.get("pattern").getAsJsonArray().asList().stream().map(text -> class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, text)).map(DataResult::result).map(Optional::get).map(class_2561.class::cast).collect(Collectors.toList()));
                counter.increment();
            } else {
                pattern = PATTERN;
            }
            DefaultPreference.charset = defaultPreference.has("charset") ? new ManaCharset(Stream.of(defaultPreference.get("charset").getAsJsonArray().asList().stream().map(JsonElement::getAsJsonArray).map(JsonArray::asList).map(charsetType -> charsetType.stream().map(text -> class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, text)).map(DataResult::result).map(Optional::get).collect(Collectors.toList())).map(charsetType -> charsetType.size() <= 127 ? Stream.concat(charsetType.stream(), Collections.nCopies(128 - charsetType.size(), (class_2561)charsetType.getFirst()).stream()).collect(Collectors.toList()) : charsetType).collect(Collectors.toList())).map(charset -> charset.size() <= 127 ? Stream.concat(charset.stream(), Collections.nCopies(128 - charset.size(), Collections.nCopies(128, class_2561.method_43470((String)"\ufffd"))).stream()).collect(Collectors.toList()) : charset).findAny().get()) : CHARSET;
            if (defaultPreference.has("pointsPerCharacter")) {
                pointsPerCharacter = defaultPreference.get("pointsPerCharacter").getAsInt();
                counter.increment();
            } else {
                pointsPerCharacter = 2;
            }
            if (defaultPreference.has("isCompressed")) {
                isCompressed = defaultPreference.get("isCompressed").getAsBoolean();
                counter.increment();
            } else {
                isCompressed = false;
            }
            if (defaultPreference.has("compressionSize")) {
                compressionSize = defaultPreference.get("compressionSize").getAsByte();
                counter.increment();
            } else {
                compressionSize = (byte)20;
            }
            if (defaultPreference.has("color")) {
                color = BossBars.Colors.byName((String)defaultPreference.get("color").getAsString());
                counter.increment();
            } else {
                color = COLOR;
            }
            if (defaultPreference.has("style")) {
                style = BossBars.Styles.byName((String)defaultPreference.get("style").getAsString());
                counter.increment();
            } else {
                style = STYLE;
            }
            PentamanaConfig.reCalc();
            return counter.intValue();
        }

        public static void reset() {
            position = POSITION;
            pattern = PATTERN;
            type = TYPE;
            charset = CHARSET;
            pointsPerCharacter = 2;
            isCompressed = false;
            compressionSize = (byte)20;
            isVisible = true;
            isSuppressed = false;
            color = COLOR;
            style = STYLE;
        }
    }
}

