/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.pentamana.mixin;

import java.util.HashMap;
import java.util.Map;
import net.hederamc.gcd.effect.ServerCustomStatusEffectManager;
import net.hederamc.pentamana.api.LivingEntityApi;
import net.hederamc.pentamana.api.event.ConsumManaCallback;
import net.hederamc.pentamana.api.event.RegenManaCallback;
import net.hederamc.pentamana.api.event.TickManaCallback;
import net.hederamc.pentamana.data.PentamanaConfig;
import net.hederamc.pentamana.effect.PentamanaStatusEffectIdentifiers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1640;
import net.minecraft.class_1893;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements LivingEntityApi {
    @Inject(method={"method_5773()V"}, at={@At(value="RETURN")})
    private void tickMana(CallbackInfo info) {
        this.tickMana();
    }

    @Override
    public void tickMana() {
        class_3222 player;
        float supply;
        class_1309 livingEntity = (class_1309)this;
        ((TickManaCallback)TickManaCallback.EVENT.invoker()).interact(livingEntity);
        boolean isValueChanged = false;
        float capacity = this.getModifiedManaCapacityBase(PentamanaConfig.manaCapacityBase);
        if (this.getManaCapacity() != capacity) {
            this.setManaCapacity(capacity);
            isValueChanged = true;
        }
        if ((supply = this.getMana()) < capacity && supply >= 0.0f) {
            isValueChanged |= this.regenMana();
        } else if (supply > capacity) {
            this.setMana(capacity);
            isValueChanged = true;
        } else if (supply < 0.0f) {
            this.setMana(0.0f);
            isValueChanged = true;
        }
        if (livingEntity instanceof class_3222 && (player = (class_3222)livingEntity).isManaBarDisplayOutdate(isValueChanged)) {
            player.putManaBarDisplay();
        }
    }

    @Override
    public boolean regenMana(float amount) {
        float presentedSupply = this.getMana();
        float targetSupply = presentedSupply + amount;
        targetSupply = Math.min(targetSupply, this.getManaCapacity());
        targetSupply = Math.max(targetSupply, 0.0f);
        this.setMana(targetSupply);
        return targetSupply != presentedSupply;
    }

    @Override
    public boolean regenMana() {
        ((RegenManaCallback)RegenManaCallback.EVENT.invoker()).interact((class_1309)this);
        return this.regenMana(this.getModifiedManaRegenerationBase(PentamanaConfig.manaRegenerationBase));
    }

    @Override
    public boolean consumMana(float amount) {
        class_1309 livingEntity = (class_1309)this;
        ((ConsumManaCallback)ConsumManaCallback.EVENT.invoker()).interact(livingEntity);
        MutableFloat consum = new MutableFloat((float)livingEntity.getCustomModifiedValue("pentamana:mana_consumption", (double)amount));
        livingEntity.getEnchantments(class_1893.MANA_EFFICIENCY).forEach(entry -> consum.setValue(consum.floatValue() * (1.0f - PentamanaConfig.enchantmentManaEfficiencyBase * (float)(entry.getIntValue() + 1))));
        float targetSupply = this.getMana() - consum.floatValue();
        if (targetSupply < 0.0f) {
            return false;
        }
        this.setMana(targetSupply);
        return true;
    }

    @Override
    public float getModifiedManaCapacityBase(float base) {
        class_1309 livingEntity = (class_1309)this;
        ServerCustomStatusEffectManager statusEffectManager = livingEntity.getCustomStatusEffectManager();
        MutableFloat capacity = new MutableFloat((float)livingEntity.getCustomModifiedValue("pentamana:mana_capacity", (double)base));
        livingEntity.getEnchantments(class_1893.CAPACITY).forEach(entry -> capacity.setValue(capacity.floatValue() + PentamanaConfig.enchantmentCapacityBase * (float)(entry.getIntValue() + 1)));
        return Math.max(capacity.floatValue() + (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_BOOST) ? PentamanaConfig.statusEffectManaBoostBase * (float)(statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_BOOST) + 1) : 0.0f) - (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_REDUCTION) ? PentamanaConfig.statusEffectManaReductionBase * (float)(statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_REDUCTION) + 1) : 0.0f) + (PentamanaConfig.shouldConvertExperienceLevel && livingEntity instanceof class_3222 ? PentamanaConfig.experienceLevelConversionBase * (float)((class_3222)livingEntity).field_7520 : 0.0f), 0.0f);
    }

    @Override
    public float getModifiedManaRegenerationBase(float base) {
        class_1309 livingEntity = (class_1309)this;
        ServerCustomStatusEffectManager statusEffectManager = livingEntity.getCustomStatusEffectManager();
        MutableFloat regen = new MutableFloat((float)livingEntity.getCustomModifiedValue("pentamana:mana_regeneration", (double)base));
        livingEntity.getEnchantments(class_1893.STREAM).forEach(entry -> regen.setValue(regen.floatValue() + PentamanaConfig.enchantmentStreamBase * (float)(entry.getIntValue() + 1)));
        return regen.floatValue() + (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.INSTANT_MANA) ? PentamanaConfig.statusEffectInstantManaBase * (float)Math.pow(2.0, statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.INSTANT_MANA)) : 0.0f) - (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.INSTANT_DEPLETE) ? PentamanaConfig.statusEffectInstantDepleteBase * (float)Math.pow(2.0, statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.INSTANT_DEPLETE)) : 0.0f) + (float)(statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_REGENERATION) ? PentamanaConfig.manaPerPoint / Math.max(1, PentamanaConfig.statusEffectManaRegenerationBase >> statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_REGENERATION)) : 0) - (float)(statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_INHIBITION) ? PentamanaConfig.manaPerPoint / Math.max(1, PentamanaConfig.statusEffectManaInhibitionBase >> statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_INHIBITION)) : 0);
    }

    @Override
    public float getMana() {
        return ((class_9279)((class_1309)this).method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_66563("mana", 0.0f);
    }

    @Override
    public void setMana(float value) {
        ((class_1309)this).method_66653(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)((class_9279)((class_1309)this).method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10543(new class_2487(new HashMap<String, class_2494>(Map.of("mana", class_2494.method_23244((float)value)))))));
    }

    @Override
    public float getManaCapacity() {
        return ((class_9279)((class_1309)this).method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_66563("mana_capacity", 0.0f);
    }

    @Override
    public void setManaCapacity(float value) {
        ((class_1309)this).method_66653(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)((class_9279)((class_1309)this).method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10543(new class_2487(new HashMap<String, class_2494>(Map.of("mana_capacity", class_2494.method_23244((float)value)))))));
    }

    @Override
    public float getCastingDamageAgainst(class_1297 entity, float baseDamage) {
        class_1309 livingEntity = (class_1309)this;
        ServerCustomStatusEffectManager statusEffectManager = livingEntity.getCustomStatusEffectManager();
        MutableFloat damage = new MutableFloat(this.getManaCapacity() / PentamanaConfig.manaCapacityBase * (float)livingEntity.getCustomModifiedValue("pentamana:casting_damage", (double)baseDamage));
        livingEntity.getEnchantments(class_1893.POTENCY).forEach(entry -> damage.setValue(damage.floatValue() + PentamanaConfig.enchantmentPotencyBase * (float)(entry.getIntValue() + 1)));
        return Math.max((damage.floatValue() + (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_POWER) ? (float)(statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_POWER) + 1) * PentamanaConfig.statusEffectManaPowerBase : 0.0f) - (statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_SICKNESS) ? (float)(statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_SICKNESS) + 1) * PentamanaConfig.statusEffectManaSicknessBase : 0.0f)) * (entity instanceof class_1640 ? 0.15f : 1.0f), 0.0f);
    }
}

