/*
 * Decompiled with CFR 0.152.
 */
package net.hederamc.pentamana.render;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.hederamc.cw.util.BossBars;
import net.hederamc.pentamana.data.PentamanaConfig;
import net.hederamc.pentamana.data.PentamanaPreference;
import net.hederamc.pentamana.render.ManaTextual;
import net.minecraft.class_1259;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2519;

public class ManaBar {
    protected float capacity;
    protected float supply;
    protected Position position;
    protected ManaTextual textual;
    protected boolean isVisible;
    protected boolean isSuppressed;
    protected class_1259.class_1260 color;
    protected class_1259.class_1261 style;

    public ManaBar(float capacity, float supply, Position position, ManaTextual textual, boolean isVisible, boolean isSuppressed, class_1259.class_1260 color, class_1259.class_1261 style) {
        this.capacity = capacity;
        this.supply = supply;
        this.position = position;
        this.textual = textual;
        this.isVisible = isVisible;
        this.isSuppressed = isSuppressed;
        this.color = color;
        this.style = style;
    }

    public boolean isFull() {
        return this.supply == this.capacity;
    }

    public boolean isEmpty() {
        return this.supply == 0.0f;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public void setCapacity(float capacity) {
        this.capacity = capacity;
    }

    public ManaBar withCapacity(float capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public float getSupply() {
        return this.supply;
    }

    public void setSupply(float supply) {
        this.supply = supply;
    }

    public ManaBar withSupply(float supply) {
        this.setSupply(supply);
        return this;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public ManaBar withPosition(Position position) {
        this.setPosition(position);
        return this;
    }

    public ManaTextual getTextual() {
        return this.textual;
    }

    public void setTextual(ManaTextual textual) {
        this.textual = textual;
    }

    public ManaBar withTextual(ManaTextual textual) {
        this.setTextual(textual);
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisibility(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public ManaBar withVisibility(boolean isVisible) {
        this.setVisibility(isVisible);
        return this;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public void setSuppression(boolean isSuppressed) {
        this.isSuppressed = isSuppressed;
    }

    public ManaBar withSuppression(boolean isSuppressed) {
        this.setSuppression(isSuppressed);
        return this;
    }

    public class_1259.class_1260 getColor() {
        return this.color;
    }

    public void setColor(class_1259.class_1260 color) {
        this.color = color;
    }

    public ManaBar withColor(class_1259.class_1260 color) {
        this.setColor(color);
        return this;
    }

    public class_1259.class_1261 getStyle() {
        return this.style;
    }

    public void setStyle(class_1259.class_1261 style) {
        this.style = style;
    }

    public ManaBar withStyle(class_1259.class_1261 style) {
        this.setStyle(style);
        return this;
    }

    public ManaBar copy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual, this.isVisible, this.isSuppressed, this.color, this.style);
    }

    public ManaBar deepCopy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual.deepCopy(), this.isVisible, this.isSuppressed, this.color, this.style);
    }

    public static ManaBar fromPreference(PentamanaPreference preference) {
        return new ManaBar(0.0f, 0.0f, preference.position, ManaTextual.fromPreference(preference), preference.isVisible, preference.isSuppressed, preference.color, preference.style);
    }

    public static ManaBar fromNbt(class_2487 nbtCompound) {
        return new ManaBar(nbtCompound.method_66563("capacity", 0.0f), nbtCompound.method_66563("supply", 0.0f), nbtCompound.method_10545("position") ? Position.byName((String)nbtCompound.method_10558("position").get()) : PentamanaConfig.DefaultPreference.position, ManaTextual.fromNbt(nbtCompound.method_68568("textual")), nbtCompound.method_68566("isVisible", PentamanaConfig.DefaultPreference.isVisible), nbtCompound.method_68566("isSuppressed", PentamanaConfig.DefaultPreference.isSuppressed), nbtCompound.method_10545("color") ? BossBars.Colors.byName((String)((String)nbtCompound.method_10558("color").get())) : PentamanaConfig.DefaultPreference.color, nbtCompound.method_10545("style") ? BossBars.Styles.byName((String)((String)nbtCompound.method_10558("style").get())) : PentamanaConfig.DefaultPreference.style);
    }

    public class_2487 toNbt() {
        return new class_2487(new HashMap(Map.ofEntries(Map.entry("capacity", class_2494.method_23244((float)this.capacity)), Map.entry("supply", class_2494.method_23244((float)this.supply)), Map.entry("position", class_2519.method_23256((String)this.position.name)), Map.entry("textual", this.textual.toNbt()), Map.entry("isVisible", class_2481.method_23234((boolean)this.isVisible)), Map.entry("isSuppressed", class_2481.method_23234((boolean)this.isSuppressed)), Map.entry("color", class_2519.method_23256((String)this.color.method_5421())), Map.entry("style", class_2519.method_23256((String)this.style.method_5425())))));
    }

    public static enum Position {
        ACTIONBAR(0, "actionbar"),
        BOSSBAR(1, "bossbar"),
        SIDERBAR(2, "siderbar");

        private byte index;
        private String name;

        private Position(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static byte getIndex(String name) {
            return Arrays.stream(Position.values()).filter(position -> position.name.equals(name)).map(position -> position.index).findAny().orElse((byte)0);
        }

        public static String getName(byte index) {
            return Arrays.stream(Position.values()).filter(position -> position.index == index).map(position -> position.name).findAny().orElse("");
        }

        public static Position byIndex(byte index) {
            return Arrays.stream(Position.values()).filter(position -> position.index == index).findAny().get();
        }

        public static Position byName(String name) {
            return Arrays.stream(Position.values()).filter(position -> position.name.equals(name)).findAny().get();
        }
    }
}

