package net.cookedseafood.inferiordata.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Iterator;
import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.inferiordata.component.CustomStatusEffectManagerComponentInstance;
import net.cookedseafood.inferiordata.effect.CustomStatusEffect;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectIdentifier;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectManager;
import net.cookedseafood.inferiordata.suggestion.CustomStatusEffectSuggestionProvider;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class CustomCommand {
    private static final SimpleCommandExceptionType UNREGISTED_EXCEPTION =
        new SimpleCommandExceptionType(class_2561.method_43470("The effect is not registed."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("custom")
            .then(
                class_2170.method_9247("effect")
                .then(
                    class_2170.method_9247("add")
                    .requires(source -> source.method_9259(2))
                    .then(
                        class_2170.method_9244("entities", class_2186.method_9306())
                        .then(
                            class_2170.method_9244("effect", StringArgumentType.string())
                            .suggests(new CustomStatusEffectSuggestionProvider())
                            .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect")))
                            .then(
                                class_2170.method_9244("duration", IntegerArgumentType.integer(1))
                                .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), IntegerArgumentType.getInteger(context, "duration")))
                                .then(
                                    class_2170.method_9244("amplifier", IntegerArgumentType.integer(0))
                                    .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), IntegerArgumentType.getInteger(context, "duration"), IntegerArgumentType.getInteger(context, "amplifier")))
                                )
                            )
                            .then(
                                class_2170.method_9247("infinite")
                                .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), -1))
                                .then(
                                    class_2170.method_9244("amplifier", IntegerArgumentType.integer(0))
                                    .executes(context -> executeGiveEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect"), -1, IntegerArgumentType.getInteger(context, "amplifier")))
                                )
                            )
                        )
                    )
                )
                .then(
                    class_2170.method_9247("clear")
                    .requires(source -> source.method_9259(2))
                    .then(
                        class_2170.method_9244("entities", class_2186.method_9306())
                        .executes(context -> executeClearEffect(context.getSource(), class_2186.method_9317(context, "entities")))
                        .then(
                            class_2170.method_9244("effect", StringArgumentType.string())
                            .suggests(new CustomStatusEffectSuggestionProvider())
                            .executes(context -> executeClearEffect(context.getSource(), class_2186.method_9317(context, "entities"), StringArgumentType.getString(context, "effect")))
                        )
                    )
                )
            )
            .then(
                class_2170.method_9247("reset")
                .executes(context -> executeReset(context.getSource()))
                .then(
                    class_2170.method_9247("effect")
                    .executes(context -> executeResetEffect(context.getSource()))
                )
            )
        );
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) throws CommandSyntaxException {
        return executeGiveEffect(source, targets, effect, 1, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration) throws CommandSyntaxException {
        return executeGiveEffect(source, targets, effect, duration, 0);
    }

    public static int executeGiveEffect(class_2168 source, Collection<? extends class_1297> targets, String effect, int duration, int amplifier) throws CommandSyntaxException {
        CustomStatusEffectIdentifier effectId = Registries.get(CustomStatusEffectIdentifier.class, class_2960.method_60654(effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }

        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();
            CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(target).getStatusEffectManager().add(new CustomStatusEffect(effectId, duration, amplifier));
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Applied effect " + effectId.getName() + " to ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Applied effect " + effectId.getName() + " to " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets) {
        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();
            CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(target).getStatusEffectManager().clear();
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Removed every effect from ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Removed every effect from " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeClearEffect(class_2168 source, Collection<? extends class_1297> targets, String effect) {
        CustomStatusEffectIdentifier effectId = Registries.get(CustomStatusEffectIdentifier.class, class_2960.method_60654(effect.replace('.', ':')));
        if (effectId == null) {
            UNREGISTED_EXCEPTION.create();
        }

        Iterator<? extends class_1297> iterator = targets.iterator();

        while (iterator.hasNext()) {
            class_1297 target = iterator.next();
            CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(target).getStatusEffectManager().remove(effectId);
        }

        int count = targets.size();
        if (count == 1) {
            source.method_9226(() -> class_2561.method_43470("Removed effect " + effectId.getName() + " from ").method_10852(targets.iterator().next().method_5476()).method_27693("."), true);
        } else {
            source.method_9226(() -> class_2561.method_43470("Removed effect " + effectId.getName() + " from " + count + " targets."), true);
        }

        return 1;
    }

    public static int executeReset(class_2168 source) throws CommandSyntaxException {
        executeResetEffect(source);
        return 1;
    }

    public static int executeResetEffect(class_2168 source) throws CommandSyntaxException {
        CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(source.method_9207()).setStatusEffectManager(new CustomStatusEffectManager());
        return 1;
    }
}
