package net.cookedseafood.inferiordata.mixin;

import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.inferiordata.component.CustomStatusEffectManagerComponentInstance;
import net.cookedseafood.inferiordata.effect.CustomStatusEffect;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectIdentifier;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectManager;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin {
    @Inject(
        method = "consumeItem()V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/item/ItemStack;isEmpty()Z",
            shift = At.Shift.AFTER
        )
    )
    private void applyPentamanaStatusEffects(CallbackInfo info) {
        CustomStatusEffectManager statusEffectManager = CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get((class_3222)(Object)this).getStatusEffectManager();
        ((class_3222)(Object)this).method_6030().getCustomStatusEffects().stream()
            .map(class_2487.class::cast)
            .forEach(presentedStatusEffect -> statusEffectManager.add(
                new CustomStatusEffect(
                    Registries.get(CustomStatusEffectIdentifier.class, class_2960.method_60654(presentedStatusEffect.method_10558("id"))),
                    presentedStatusEffect.method_10550("duration"),
                    presentedStatusEffect.method_10550("amplifier")
                )
            ));
    }
}
