package net.cookedseafood.inferiordata.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.cookedseafood.genericregistry.registry.Registries;
import net.cookedseafood.genericregistry.registry.Registry;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectIdentifier;
import net.minecraft.class_2168;
import net.minecraft.class_2172;

public class CustomStatusEffectSuggestionProvider implements SuggestionProvider<class_2168> {
    @Override
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        Registry<CustomStatusEffectIdentifier> registry = Registries.get(CustomStatusEffectIdentifier.class);

        if (registry != null) {
            registry.keySet().forEach(id -> {
                String candidate = id.toString().replace(':', '.');

                if (class_2172.method_27136(builder.getRemaining(), candidate)) {
                    builder.suggest(candidate);
                }
            });
        }

        return builder.buildFuture();
    }
}
