package net.cookedseafood.pentamana.command;

import java.util.List;
import java.util.stream.IntStream;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.component.ServerManaBarComponentInstance;
import net.cookedseafood.pentamana.mana.ManaBar;
import net.cookedseafood.pentamana.mana.ManaCharset;
import net.cookedseafood.pentamana.mana.ManaPattern;
import net.cookedseafood.pentamana.mana.ManaRender;
import net.cookedseafood.pentamana.mana.ManaTextual;
import net.cookedseafood.pentamana.mana.ServerManaBar;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.apache.commons.lang3.mutable.MutableInt;

public class ManaBarCommand {
    private static final DynamicCommandExceptionType OPTION_VISIBILITY_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(isVisible -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)isVisible + " for manabar visibility."));
    private static final DynamicCommandExceptionType OPTION_COMPRESSION_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(isCompression -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)isCompression + " for manabar compression."));
    private static final DynamicCommandExceptionType OPTION_COMPRESSION_SIZE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(compressionSize -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)compressionSize + " for manabar compression size."));
    private static final DynamicCommandExceptionType OPTION_PATTERN_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(pattern -> class_2561.method_43470("Nothing changed. That player already has " + (String)pattern + " for manabar pattern."));
    private static final DynamicCommandExceptionType OPTION_TYPE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(type -> class_2561.method_43470("Nothing changed. That player already has " + (String)type + " for manabar type."));
    private static final DynamicCommandExceptionType OPTION_POSITION_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(position -> class_2561.method_43470("Nothing changed. That player already has " + (String)position + " for manabar position."));
    private static final DynamicCommandExceptionType OPTION_COLOR_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(color -> class_2561.method_43470("Nothing changed. That player already has " + (String)color + " for manabar color."));
    private static final DynamicCommandExceptionType OPTION_STYLE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(style -> class_2561.method_43470("Nothing changed. That player already has " + (String)style + " for manabar style."));
    private static final DynamicCommandExceptionType OPTION_POINTS_PER_CHARACTER_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(pointsPerCharacter -> class_2561.method_43470("Nothing changed. That player already has " + (int)pointsPerCharacter + " for points per character."));
    private static final Dynamic3CommandExceptionType OPTION_MANA_CHARACTER_UNCHANGED_EXCEPTION =
        new Dynamic3CommandExceptionType((manaCharacter, manaCharacterTypeIndex, manaCharacterIndex) -> class_2561.method_43470("Nothing changed. That player already has " + (String)manaCharacter + " for" + ((int)manaCharacterIndex == -1 ? "" : (" #" + (int)manaCharacterIndex)) + ((int)manaCharacterTypeIndex == -1 ? "" : (" " + (int)manaCharacterTypeIndex + " point")) + " mana character."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("manabar")
            .then(
                class_2170.method_9247("set")
                .then(
                    class_2170.method_9247("visibility")
                    .then(
                        class_2170.method_9247("false")
                        .executes(context -> executeSetVisibility(context.getSource(), false))
                    )
                    .then(
                        class_2170.method_9247("true")
                        .executes(context -> executeSetVisibility(context.getSource(), true))
                    )
                )
                .then(
                    class_2170.method_9247("position")
                    .then(
                        class_2170.method_9247("actionbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.ACTIONBAR))
                    )
                    .then(
                        class_2170.method_9247("bossbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.BOSSBAR))
                    )
                    .then(
                        class_2170.method_9247("siderbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.SIDERBAR))
                    )
                )
                .then(
                    class_2170.method_9247("color")
                    .then(
                        class_2170.method_9247("pink")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5788))
                    )
                    .then(
                        class_2170.method_9247("blue")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5780))
                    )
                    .then(
                        class_2170.method_9247("red")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5784))
                    )
                    .then(
                        class_2170.method_9247("green")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5785))
                    )
                    .then(
                        class_2170.method_9247("yellow")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5782))
                    )
                    .then(
                        class_2170.method_9247("purple")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5783))
                    )
                    .then(
                        class_2170.method_9247("white")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5786))
                    )
                )
                .then(
                    class_2170.method_9247("style")
                    .then(
                        class_2170.method_9247("progress")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5795))
                    )
                    .then(
                        class_2170.method_9247("notched_6")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5796))
                    )
                    .then(
                        class_2170.method_9247("notched_10")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5791))
                    )
                    .then(
                        class_2170.method_9247("notched_12")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5793))
                    )
                    .then(
                        class_2170.method_9247("notched_20")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5790))
                    )
                )
                .then(
                    class_2170.method_9247("pattern")
                    .then(
                        class_2170.method_9244("text", class_2178.method_9281(registryAccess))
                        .executes(context -> executeSetPattern(context.getSource(), class_2178.method_9280(context, "text")))
                    )
                )
                .then(
                    class_2170.method_9247("type")
                    .then(
                        class_2170.method_9247("character")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.CHARACTER))
                    )
                    .then(
                        class_2170.method_9247("numeric")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.NUMERIC))
                    )
                    .then(
                        class_2170.method_9247("percentage")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.PERCENTAGE))
                    )
                    .then(
                        class_2170.method_9247("none")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.NONE))
                    )
                )
                .then(
                    class_2170.method_9247("points_per_character")
                    .then(
                        class_2170.method_9244("value", IntegerArgumentType.integer(1))
                        .executes(context -> executeSetPointsPerCharacter(context.getSource(), IntegerArgumentType.getInteger(context, "value")))
                    )
                )
                .then(
                    class_2170.method_9247("compression")
                    .then(
                        class_2170.method_9247("false")
                        .executes(context -> executeSetCompression(context.getSource(), false))
                    )
                    .then(
                        class_2170.method_9247("true")
                        .executes(context -> executeSetCompression(context.getSource(), true))
                    )
                )
                .then(
                    class_2170.method_9247("compression_size")
                    .then(
                        class_2170.method_9244("size", IntegerArgumentType.integer(1, Pentamana.MANA_CHARACTER_INDEX_LIMIT + 1))
                        .executes(context -> executeSetCompressionSize(context.getSource(), (byte)IntegerArgumentType.getInteger(context, "size")))
                    )
                )
                .then(
                    class_2170.method_9247("character")
                    .then(
                        class_2170.method_9244("text", class_2178.method_9281(registryAccess))
                        .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_9280(context, "text")))
                        .then(
                            class_2170.method_9244("character_type_index", IntegerArgumentType.integer(0, Pentamana.MANA_CHARACTER_TYPE_INDEX_LIMIT))
                            .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_9280(context, "text"), IntegerArgumentType.getInteger(context, "type_index")))
                            .then(
                                class_2170.method_9244("character_index", IntegerArgumentType.integer(0, Pentamana.MANA_CHARACTER_INDEX_LIMIT))
                                .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_9280(context, "text"), IntegerArgumentType.getInteger(context, "type_index"), IntegerArgumentType.getInteger(context, "character_index")))
                            )
                        )
                    )
                )
            )
            .then(
                class_2170.method_9247("reset")
                .executes(context -> executeReset(context.getSource()))
                .then(
                    class_2170.method_9247("visibility")
                    .executes(context -> executeResetVisibility(context.getSource()))
                )
                .then(
                    class_2170.method_9247("compression")
                    .executes(context -> executeResetCompression(context.getSource()))
                )
                .then(
                    class_2170.method_9247("compression_size")
                    .executes(context -> executeResetCompressionSize(context.getSource()))
                )
                .then(
                    class_2170.method_9247("pattern")
                    .executes(context -> executeResetPattern(context.getSource()))
                )
                .then(
                    class_2170.method_9247("type")
                    .executes(context -> executeResetType(context.getSource()))
                )
                .then(
                    class_2170.method_9247("position")
                    .executes(context -> executeResetPosition(context.getSource()))
                )
                .then(
                    class_2170.method_9247("color")
                    .executes(context -> executeResetColor(context.getSource()))
                )
                .then(
                    class_2170.method_9247("style")
                    .executes(context -> executeResetStyle(context.getSource()))
                )
                .then(
                    class_2170.method_9247("points_per_character")
                    .executes(context -> executeResetPointsPerCharacter(context.getSource()))
                )
                .then(
                    class_2170.method_9247("character")
                    .executes(context -> executeResetCharacter(context.getSource()))
                )
            )
        );
    }

    public static int executeSetVisibility(class_2168 source, boolean isVisible) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        if (serverManaBar.isVisible() == isVisible) {
            throw OPTION_VISIBILITY_UNCHANGED_EXCEPTION.create(isVisible);
        }

        serverManaBar.setIsVisible(isVisible);

        source.method_9226(() -> class_2561.method_43470("Updated manabar visibility for player ").method_10852(player.method_5476()).method_27693(" to " + isVisible + "."), false);
        return 1;
    }

    public static int executeSetPosition(class_2168 source, ManaBar.Position manaBarPosition) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        if (serverManaBar.getPosition() == manaBarPosition) {
            throw OPTION_POSITION_UNCHANGED_EXCEPTION.create(manaBarPosition.getName());
        }

        serverManaBar.setPosition(manaBarPosition);

        source.method_9226(() -> class_2561.method_43470("Updated manabar position for player ").method_10852(player.method_5476()).method_27693(" to " + manaBarPosition.getName() + "."), false);
        return 1;
    }

    public static int executeSetColor(class_2168 source, class_1259.class_1260 manaBarColor) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        if (serverManaBar.getColor() == manaBarColor) {
            throw OPTION_COLOR_UNCHANGED_EXCEPTION.create(manaBarColor.method_5421());
        }

        serverManaBar.setColor(manaBarColor);

        source.method_9226(() -> class_2561.method_43470("Updated manabar color for player ").method_10852(player.method_5476()).method_27693(" to " + manaBarColor.method_5421() + "."), false);
        return 1;
    }

    public static int executeSetStyle(class_2168 source, class_1259.class_1261 manaBarStyle) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        if (serverManaBar.getStyle() == manaBarStyle) {
            throw OPTION_STYLE_UNCHANGED_EXCEPTION.create(manaBarStyle.method_5425());
        }

        serverManaBar.setStyle(manaBarStyle);

        source.method_9226(() -> class_2561.method_43470("Updated manabar style for player ").method_10852(player.method_5476()).method_27693(" to " + manaBarStyle.method_5425() + "."), false);
        return 1;
    }

    public static int executeSetPattern(class_2168 source, class_2561 manaBarPattern) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaPattern manaPattern = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getPattern();
        List<class_2561> targetManabarPattern = manaBarPattern.method_10855();
        if (manaPattern.getPattern().equals(targetManabarPattern)) {
            throw OPTION_PATTERN_UNCHANGED_EXCEPTION.create(manaBarPattern.getString());
        }

        manaPattern.setPattern(targetManabarPattern);

        source.method_9226(() -> class_2561.method_43470("Updated manabar pattern for player").method_10852(player.method_5476()).method_27693(" to " + manaBarPattern.getString() + "."), false);
        return 1;
    }

    public static int executeSetType(class_2168 source, ManaRender.Type manaBarType) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaRender manaRender = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender();
        if (manaRender.getType() == manaBarType) {
            throw OPTION_TYPE_UNCHANGED_EXCEPTION.create(manaBarType.getName());
        }

        manaRender.setType(manaBarType);

        source.method_9226(() -> class_2561.method_43470("Updated manabar type for player ").method_10852(player.method_5476()).method_27693(" to " + manaBarType.getName() + "."), false);
        return 1;
    }

    public static int executeSetPointsPerCharacter(class_2168 source, int pointsPerCharacter) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaRender manaRender = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender();
        if (manaRender.getPointsPerCharacter() == pointsPerCharacter) {
            throw OPTION_POINTS_PER_CHARACTER_UNCHANGED_EXCEPTION.create(pointsPerCharacter);
        }

        manaRender.setPointsPerCharacter(pointsPerCharacter);

        source.method_9226(() -> class_2561.method_43470("Updated points per character for player ").method_10852(player.method_5476()).method_27693(" to " + pointsPerCharacter + "."), false);
        return 1;
    }

    public static int executeSetCompression(class_2168 source, boolean isCompression) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaRender manaRender = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender();
        if (manaRender.isCompression() == isCompression) {
            throw OPTION_COMPRESSION_UNCHANGED_EXCEPTION.create(isCompression);
        }

        manaRender.setIsCompression(isCompression);

        source.method_9226(() -> class_2561.method_43470("Updated manabar compression for player ").method_10852(player.method_5476()).method_27693(" to " + isCompression + "."), false);
        return 1;
    }

    public static int executeSetCompressionSize(class_2168 source, byte compressionSize) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaRender manaRender = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender();
        if (manaRender.getCompressionSize() == compressionSize) {
            throw OPTION_COMPRESSION_SIZE_UNCHANGED_EXCEPTION.create(compressionSize);
        }

        manaRender.setCompressionSize(compressionSize);

        source.method_9226(() -> class_2561.method_43470("Updated manabar compression size for player ").method_10852(player.method_5476()).method_27693(" to " + compressionSize + "."), false);
        return 1;
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetManaCharacter) throws CommandSyntaxException {
        return executeSetCharacter(source, targetManaCharacter, -1);
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetManaCharacter, int manaCharacterTypeIndex) throws CommandSyntaxException {
        return executeSetCharacter(source, targetManaCharacter, manaCharacterTypeIndex, -1);
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetManaCharacter, int manaCharacterTypeIndex, int manaCharacterIndex) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaCharset manaCharset = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().getCharset();
        List<List<class_2561>> manaCharacter = manaCharset.getCharset();

        int startManaCharTypeIndex = manaCharacterTypeIndex == -1 ? 0 : manaCharacterTypeIndex;
        int endManaCharTypeIndex = manaCharacterTypeIndex == -1 ? Pentamana.MANA_CHARACTER_TYPE_INDEX_LIMIT : manaCharacterTypeIndex;
        int startManaCharIndex = manaCharacterIndex == -1 ? 0 : manaCharacterIndex;
        int endManaCharIndex = manaCharacterIndex == -1 ? Pentamana.MANA_CHARACTER_INDEX_LIMIT : manaCharacterIndex;

        MutableInt miss = new MutableInt(0);
        IntStream.rangeClosed(startManaCharTypeIndex, endManaCharTypeIndex)
            .forEach(cti -> IntStream.rangeClosed(startManaCharIndex, endManaCharIndex)
                .forEach(ci -> {
                    if (!manaCharacter.get(cti).get(ci).equals(targetManaCharacter)) {
                        miss.increment();
                        manaCharacter.get(cti).set(ci, targetManaCharacter);
                    }
                })
            );

        if (miss.intValue() == 0) {
            throw OPTION_MANA_CHARACTER_UNCHANGED_EXCEPTION.create(targetManaCharacter, manaCharacterTypeIndex, manaCharacterIndex);
        }

        source.method_9226(() -> class_2561.method_43470("Updated " + (manaCharacterIndex == -1 ? "" : (" #" + manaCharacterIndex)) + (manaCharacterTypeIndex == -1 ? "" : (" " + manaCharacterTypeIndex + " point")) + " mana character for player ").method_10852(player.method_5476()).method_27693(" to " + targetManaCharacter.getString() + "."), false);
        return 1;
    }

    public static int executeReset(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        ManaTextual textual = serverManaBar.getTextual();
        ManaPattern pattern = textual.getPattern();
        ManaRender render = textual.getRender();
        ManaCharset charset = render.getCharset();
        serverManaBar.setIsVisible(Pentamana.isVisible);
        serverManaBar.setPosition(Pentamana.manaBarPosition);
        serverManaBar.setColor(Pentamana.manaBarColor);
        serverManaBar.setStyle(Pentamana.manaBarStyle);
        pattern.setPattern(Pentamana.manaPattern.deepCopy().getPattern());
        render.setType(Pentamana.manaRenderType);
        render.setPointsPerCharacter(Pentamana.pointsPerCharacter);
        render.setIsCompression(Pentamana.isCompression);
        render.setCompressionSize(Pentamana.compressionSize);
        charset.setCharset(Pentamana.manaCharset.deepCopy().getCharset());

        source.method_9226(() -> class_2561.method_43470("Reset manabar options for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetVisibility(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().setIsVisible(Pentamana.isVisible);

        source.method_9226(() -> class_2561.method_43470("Reset manabar visibility for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetPosition(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().setPosition(Pentamana.manaBarPosition);

        source.method_9226(() -> class_2561.method_43470("Reset manabar position for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetColor(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().setColor(Pentamana.manaBarColor);

        source.method_9226(() -> class_2561.method_43470("Reset manabar color for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetStyle(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().setStyle(Pentamana.manaBarStyle);

        source.method_9226(() -> class_2561.method_43470("Reset manabar style for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetPattern(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().setPattern(Pentamana.manaPattern);

        source.method_9226(() -> class_2561.method_43470("Reset manabar pattern for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetType(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().setType(Pentamana.manaRenderType);

        source.method_9226(() -> class_2561.method_43470("Reset manabar type for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetPointsPerCharacter(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().setPointsPerCharacter(Pentamana.pointsPerCharacter);

        source.method_9226(() -> class_2561.method_43470("Reset points per character for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCompression(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().setIsCompression(Pentamana.isCompression);

        source.method_9226(() -> class_2561.method_43470("Reset manabar compression for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCompressionSize(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().setCompressionSize(Pentamana.compressionSize);

        source.method_9226(() -> class_2561.method_43470("Reset manabar compression size for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCharacter(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getTextual().getRender().getCharset().setCharset(Pentamana.manaCharset.deepCopy().getCharset());

        source.method_9226(() -> class_2561.method_43470("Reset mana character for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }
}
