package net.cookedseafood.pentamana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.component.ManaPreferenceComponentInstance;
import net.cookedseafood.pentamana.component.ServerManaBarComponentInstance;
import net.cookedseafood.pentamana.mana.ServerManaBar;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ManaCommand {
    private static final SimpleCommandExceptionType OPTION_ALREADY_ENABLED_EXCEPTION =
        new SimpleCommandExceptionType(class_2561.method_43470("Nothing changed. Mana is already enabled for that player."));
    private static final SimpleCommandExceptionType OPTION_ALREADY_DISABLED_EXCEPTION =
        new SimpleCommandExceptionType(class_2561.method_43470("Nothing changed. Mana is already disbaled for that player."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("mana")
            .then(
                class_2170.method_9247("disable")
                .executes(context -> executeDisable(context.getSource()))
            )
            .then(
                class_2170.method_9247("enable")
                .executes(context -> executeEnable(context.getSource()))
            )
            .then(
                class_2170.method_9247("get")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSet(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("set")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSet(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("add")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeAdd(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("subtract")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSubtract(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("reload")
                .requires(source -> source.method_9259(2))
                .executes(context -> executeReload(context.getSource()))
            )
        );
    }

    public static int executeEnable(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaPreferenceComponentInstance manaPreference = ManaPreferenceComponentInstance.MANA_PREFERENCE.get(player);
        if (manaPreference.isEnabled()) {
            throw OPTION_ALREADY_ENABLED_EXCEPTION.create();
        }

        manaPreference.setIsEnabled(true);

        source.method_9226(() -> class_2561.method_43470("Enabled mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 1;
    }

    public static int executeDisable(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaPreferenceComponentInstance manaPreference = ManaPreferenceComponentInstance.MANA_PREFERENCE.get(player);
        if (!manaPreference.isEnabled()) {
            throw OPTION_ALREADY_DISABLED_EXCEPTION.create();
        }

        manaPreference.setIsEnabled(false);

        source.method_9226(() -> class_2561.method_43470("Disabled mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        if (Pentamana.isForceEnabled) {
            source.method_9226(() -> class_2561.method_43470("Mana calculation will continue due to the force enabled mode is turned on in server."), false);
        }

        return 1;
    }

    public static int executeGet(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        float supply = serverManaBar.getSupply();
        source.method_9226(() -> class_2561.method_43470(player.method_5820() + " has " + supply + " mana."), false);
        return (int)(supply / Pentamana.manaPerPoint);
    }

    public static int executeSet(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        serverManaBar.setSupply(amount);
        source.method_9226(() -> class_2561.method_43470("Set mana for player ").method_10852(player.method_5476()).method_27693(" to " + amount + "."), false);
        return (int)(amount / Pentamana.manaPerPoint);
    }

    public static int executeAdd(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        float targetSupply = serverManaBar.getSupply() + amount;
        serverManaBar.setSupply(targetSupply);
        source.method_9226(() -> class_2561.method_43470("Added " + amount + " mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        return (int)(targetSupply / Pentamana.manaPerPoint);
    }

    public static int executeSubtract(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        float targetSupply = serverManaBar.getSupply() - amount;
        serverManaBar.setSupply(targetSupply);
        source.method_9226(() -> class_2561.method_43470("Subtracted " + amount + " mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        return (int)(targetSupply / Pentamana.manaPerPoint);
    }

    public static int executeReload(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470("Reloading Pentamana!"), true);
        return Pentamana.reload(source.method_9211());
    }
}
