package net.cookedseafood.pentamana.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.cookedseafood.inferiordata.component.CustomStatusEffectManagerComponentInstance;
import net.cookedseafood.inferiordata.effect.CustomStatusEffectManager;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.component.ManaPreferenceComponentInstance;
import net.cookedseafood.pentamana.component.ServerManaBarComponentInstance;
import net.cookedseafood.pentamana.mana.ManaBar;
import net.cookedseafood.pentamana.mana.ManaCharset;
import net.cookedseafood.pentamana.mana.ManaPattern;
import net.cookedseafood.pentamana.mana.ManaRender;
import net.cookedseafood.pentamana.mana.ManaTextual;
import net.cookedseafood.pentamana.mana.ServerManaBar;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class PentamanaCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247(Pentamana.MOD_ID)
            .then(
                class_2170.method_9247("debug")
                .then(
                    class_2170.method_9247("manabar")
                    .then(
                        class_2170.method_9247("server")
                        .executes(context -> executeDebugManaBarServer(context.getSource()))
                        .then(
                            class_2170.method_9244("player", class_2186.method_9305())
                            .executes(context -> executeDebugManaBarServer(context.getSource(), class_2186.method_9315(context, "player")))
                        )
                    )
                    .then(
                        class_2170.method_9247("client")
                        .executes(context -> executeDebugManaBarClient(context.getSource()))
                        .then(
                            class_2170.method_9244("player", class_2186.method_9305())
                            .executes(context -> executeDebugManaBarClient(context.getSource(), class_2186.method_9315(context, "player")))
                        )
                    )
                )
                .then(
                    class_2170.method_9247("config")
                    .executes(context -> executeDebugConfig(context.getSource()))
                )
            )
            .then(
                class_2170.method_9247("version")
                .executes(context -> executeVersion(context.getSource()))
            )
        );
    }

    public static int executeDebugManaBarServer(class_2168 source) throws CommandSyntaxException {
        return executeDebugManaBarServer(source, source.method_9207());
    }

    public static int executeDebugManaBarServer(class_2168 source, class_3222 player) throws CommandSyntaxException {
        ManaPreferenceComponentInstance manaPreference = ManaPreferenceComponentInstance.MANA_PREFERENCE.get(player);
        CustomStatusEffectManager statusEffectManager = CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(player).getStatusEffectManager();
        ServerManaBar serverManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar();
        ManaTextual textual = serverManaBar.getTextual();
        ManaPattern pattern = textual.getPattern();
        ManaRender render = textual.getRender();
        ManaCharset charset = render.getCharset();
        class_1259.class_1260 color = serverManaBar.getColor();
        class_1259.class_1261 style = serverManaBar.getStyle();

        class_5250 profile = class_5250.method_43477(class_8828.field_46625);
        profile.method_10852(class_2561.method_43470("\n" + serverManaBar.getSupply() + "/" + serverManaBar.getCapacity()).method_27692(class_124.field_1075));
        profile.method_10852(class_2561.method_43470(" " + serverManaBar.getLife()).method_27692(class_124.field_1080));
        statusEffectManager.values().forEach(playlist -> {
            profile.method_10852(class_2561.method_43470("\n" + playlist.getId().getId().toString()).method_27692(class_124.field_1054));
            profile.method_10852(class_2561.method_43470(" " + playlist.getActiveDuration()).method_27692(class_124.field_1060));
            profile.method_10852(class_2561.method_43470(" " + playlist.getActiveAmplifier()).method_27692(class_124.field_1076));
            profile.method_10852(class_2561.method_43470(" " + playlist.getId().getColor()).method_27692(class_124.field_1080));
        });
        profile.method_10852(class_2561.method_43470("\n- isEnabled "));
        profile.method_10852(manaPreference.isEnabled() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- manaBarPosition "));
        profile.method_10852(class_2561.method_43470(serverManaBar.getPosition().getName()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaPattern "));
        profile.method_10852(class_2561.method_43470(pattern.toText().toString()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaRenderType "));
        profile.method_10852(class_2561.method_43470(render.getType().getName()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaCharset "));
        for (int i = 0; i < 10; i++) {
            profile.method_10852(charset.get(i).get(i));
        };
        profile.method_10852(class_2561.method_43470("\n- pointsPerCharacter "));
        profile.method_10852(class_2561.method_43470("" + render.getPointsPerCharacter()).method_27692(class_124.field_1060));
        profile.method_10852(class_2561.method_43470("\n- isCompression "));
        profile.method_10852(render.isCompression() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- compressionSize "));
        profile.method_10852(class_2561.method_43470("" + render.getCompressionSize()).method_27692(class_124.field_1060));
        profile.method_10852(class_2561.method_43470("\n- isVisible "));
        profile.method_10852(serverManaBar.isVisible() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- manaBarColor "));
        profile.method_10852(class_2561.method_43470("" + color.method_5421()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaBarStyle "));
        profile.method_10852(class_2561.method_43470("" + style.method_5425()).method_27692(class_124.field_1054));

        source.method_9226(() -> profile, false);
        return 0;
    }

    public static int executeDebugManaBarClient(class_2168 source) throws CommandSyntaxException {
        return executeDebugManaBarClient(source, source.method_9207());
    }

    public static int executeDebugManaBarClient(class_2168 source, class_3222 player) throws CommandSyntaxException {
        ManaPreferenceComponentInstance manaPreference = ManaPreferenceComponentInstance.MANA_PREFERENCE.get(player);
        CustomStatusEffectManager statusEffectManager = CustomStatusEffectManagerComponentInstance.CUSTOM_STATUS_EFFECT_MANAGER.get(player).getStatusEffectManager();
        ManaBar clientManaBar = ServerManaBarComponentInstance.SERVER_MANA_BAR.get(player).getServerManaBar().getClientManaBar();
        ManaTextual textual = clientManaBar.getTextual();
        ManaPattern pattern = textual.getPattern();
        ManaRender render = textual.getRender();
        ManaCharset charset = render.getCharset();
        class_1259.class_1260 color = clientManaBar.getColor();
        class_1259.class_1261 style = clientManaBar.getStyle();

        class_5250 profile = class_5250.method_43477(class_8828.field_46625);
        profile.method_10852(class_2561.method_43470("\n" + clientManaBar.getSupply() + "/" + clientManaBar.getCapacity()).method_27692(class_124.field_1075));
        statusEffectManager.values().forEach(playlist -> {
            profile.method_10852(class_2561.method_43470("\n" + playlist.getId().getId().toString()).method_27692(class_124.field_1054));
            profile.method_10852(class_2561.method_43470(" " + playlist.getActiveDuration()).method_27692(class_124.field_1060));
            profile.method_10852(class_2561.method_43470(" " + playlist.getActiveAmplifier()).method_27692(class_124.field_1076));
            profile.method_10852(class_2561.method_43470(" " + playlist.getId().getColor()).method_27692(class_124.field_1080));
        });
        profile.method_10852(class_2561.method_43470("\n- isEnabled "));
        profile.method_10852(manaPreference.isEnabled() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- manaBarPosition "));
        profile.method_10852(class_2561.method_43470(clientManaBar.getPosition().getName()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaPattern "));
        profile.method_10852(class_2561.method_43470(pattern.toText().toString()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaRenderType "));
        profile.method_10852(class_2561.method_43470(render.getType().getName()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaCharset "));
        for (int i = 0; i < 10; i++) {
            profile.method_10852(charset.get(i).get(i));
        };
        profile.method_10852(class_2561.method_43470("\n- pointsPerCharacter "));
        profile.method_10852(class_2561.method_43470("" + render.getPointsPerCharacter()).method_27692(class_124.field_1060));
        profile.method_10852(class_2561.method_43470("\n- isCompression "));
        profile.method_10852(render.isCompression() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- compressionSize "));
        profile.method_10852(class_2561.method_43470("" + render.getCompressionSize()).method_27692(class_124.field_1060));
        profile.method_10852(class_2561.method_43470("\n- isVisible "));
        profile.method_10852(clientManaBar.isVisible() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        profile.method_10852(class_2561.method_43470("\n- manaBarColor "));
        profile.method_10852(class_2561.method_43470("" + color.method_5421()).method_27692(class_124.field_1054));
        profile.method_10852(class_2561.method_43470("\n- manaBarStyle "));
        profile.method_10852(class_2561.method_43470("" + style.method_5425()).method_27692(class_124.field_1054));

        source.method_9226(() -> profile, false);
        return 0;
    }

    public static int executeDebugConfig(class_2168 source) {
        String configString;
        try {
            configString = FileUtils.readFileToString(new File("./config/pentamana.json"), StandardCharsets.UTF_8);
        } catch (IOException e) {
            source.method_9226(() -> class_2561.method_43470("\nPentamana config:\nThere is no config file."), false);
            return 0;
        }

        JsonObject config = new Gson().fromJson(configString, JsonObject.class);
        MinecraftServer server = source.method_9211();
        MutableInt counter = new MutableInt(0);

        class_5250 profile = class_5250.method_43477(class_8828.field_46625);
        profile.method_10852(class_2561.method_43470("\nPentamana config:"));

        if (config.has("manaPerPoint")) {
            profile.method_10852(class_2561.method_43470("\n- manaPerPoint "));
            profile.method_10852(class_2561.method_43470("" + config.get("manaPerPoint").getAsInt()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("manaCapacityBase")) {
            profile.method_10852(class_2561.method_43470("\n- manaCapacityBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("manaCapacityBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("manaRegenerationBase")) {
            profile.method_10852(class_2561.method_43470("\n- manaRegenerationBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("manaRegenerationBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("enchantmentCapacityBase")) {
            profile.method_10852(class_2561.method_43470("\n- enchantmentCapacityBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("enchantmentCapacityBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("enchantmentStreamBase")) {
            profile.method_10852(class_2561.method_43470("\n- enchantmentStreamBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("enchantmentStreamBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("enchantmentUtilizationBase")) {
            profile.method_10852(class_2561.method_43470("\n- enchantmentUtilizationBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("enchantmentUtilizationBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("enchantmentPotencyBase")) {
            profile.method_10852(class_2561.method_43470("\n- enchantmentPotencyBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("enchantmentPotencyBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaBoostBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaBoostBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaBoostBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaReductionBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaReductionBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaReductionBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectInstantManaBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectInstantManaBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectInstantManaBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectInstantDepleteBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectInstantDepleteBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectInstantDepleteBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaPowerBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaPowerBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaPowerBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaSicknessBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaSicknessBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaSicknessBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaRegenerationBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaRegenerationBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaRegenerationBase").getAsInt()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("statusEffectManaInhibitionBase")) {
            profile.method_10852(class_2561.method_43470("\n- statusEffectManaInhibitionBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("statusEffectManaInhibitionBase").getAsInt()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("isConversionExperienceLevel")) {
            profile.method_10852(class_2561.method_43470("\n- isConversionExperienceLevel "));
            profile.method_10852(config.get("isConversionExperienceLevel").getAsBoolean() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
            counter.increment();
        }

        if (config.has("conversionExperienceLevelBase")) {
            profile.method_10852(class_2561.method_43470("\n- conversionExperienceLevelBase "));
            profile.method_10852(class_2561.method_43470("" + config.get("conversionExperienceLevelBase").getAsFloat()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("displayIdleInterval")) {
            profile.method_10852(class_2561.method_43470("\n- displayIdleInterval "));
            profile.method_10852(class_2561.method_43470("" + config.get("displayIdleInterval").getAsByte()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("displaySuppressionInterval")) {
            profile.method_10852(class_2561.method_43470("\n- displaySuppressionInterval "));
            profile.method_10852(class_2561.method_43470("" + config.get("displaySuppressionInterval").getAsByte()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("isForceEnabled")) {
            profile.method_10852(class_2561.method_43470("\n- isForceEnabled "));
            profile.method_10852(config.get("isForceEnabled").getAsBoolean() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
            counter.increment();
        }

        if (config.has("isEnabled")) {
            profile.method_10852(class_2561.method_43470("\n- isEnabled "));
            profile.method_10852(config.get("isEnabled").getAsBoolean() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
            counter.increment();
        }

        if (config.has("manaBarPosition")) {
            profile.method_10852(class_2561.method_43470("\n- manaBarPosition "));
            profile.method_10852(class_2561.method_43470(config.get("manaBarPosition").getAsString()).method_27692(class_124.field_1054));
            counter.increment();
        }

        if (config.has("manaPattern")) {
            profile.method_10852(class_2561.method_43470("\n- manaPattern "));
            profile.method_10852(
                class_2561.method_43470(
                    new ManaPattern(
                        config.get("pattern").getAsJsonArray().asList().stream()
                            .map(partialPattern -> class_2561.class_2562.method_10872(partialPattern, server.method_30611()))
                            .map(class_2561.class::cast)
                            .collect(Collectors.toList())
                    ).toText().toString()
                ).method_27692(class_124.field_1054)
            );
            counter.increment();
        }

        if (config.has("manaRenderType")) {
            profile.method_10852(class_2561.method_43470("\n- manaRenderType "));
            profile.method_10852(class_2561.method_43470(config.get("manaRenderType").getAsString()).method_27692(class_124.field_1054));
            counter.increment();
        }

        if (config.has("manaCharset")) {
            profile.method_10852(class_2561.method_43470("\n- manaCharset "));
            profile.method_10852(
                class_2561.method_43470(
                    new ManaCharset(
                        config.get("charset").getAsJsonArray().asList().stream()
                            .map(JsonElement::getAsJsonArray)
                            .map(JsonArray::asList)
                            .map(charsetType -> charsetType.stream()
                                .map(character -> class_2561.class_2562.method_10872(character, server.method_30611()))
                                .map(class_2561.class::cast)
                                .collect(Collectors.toList())
                            )
                            .collect(Collectors.toList())
                    ).toText().toString()
                ).method_27692(class_124.field_1054)
            );
        }

        if (config.has("pointsPerCharacter")) {
            profile.method_10852(class_2561.method_43470("\n- pointsPerCharacter "));
            profile.method_10852(class_2561.method_43470("" + config.get("pointsPerCharacter").getAsInt()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("isCompression")) {
            profile.method_10852(class_2561.method_43470("\n- isCompression "));
            profile.method_10852(config.get("isCompression").getAsBoolean() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
            counter.increment();
        }

        if (config.has("compressionSize")) {
            profile.method_10852(class_2561.method_43470("\n- compressionSize "));
            profile.method_10852(class_2561.method_43470("" + config.get("compressionSize").getAsByte()).method_27692(class_124.field_1060));
            counter.increment();
        }

        if (config.has("isVisible")) {
            profile.method_10852(class_2561.method_43470("\n- isVisible "));
            profile.method_10852(config.get("isVisible").getAsBoolean() ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
            counter.increment();
        }

        if (config.has("manaBarColor")) {
            profile.method_10852(class_2561.method_43470("\n- manaBarColor "));
            profile.method_10852(class_2561.method_43470(config.get("manaBarColor").getAsString()).method_27692(class_124.field_1054));
            counter.increment();
        }

        if (config.has("manaBarStyle")) {
            profile.method_10852(class_2561.method_43470("\n- manaBarStyle "));
            profile.method_10852(class_2561.method_43470(config.get("manaBarStyle").getAsString()).method_27692(class_124.field_1054));
            counter.increment();
        }

        source.method_9226(() -> profile, false);
        return counter.intValue();
    }

    public static int executeVersion(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470("Pentamana " + Pentamana.VERSION_MAJOR + "." + Pentamana.VERSION_MINOR + "." + Pentamana.VERSION_PATCH + (Pentamana.isForceEnabled ? " (Force Enabled Mode)" : "")), false);
        return 0;
    }
}
