package net.cookedseafood.pentamana.component;

import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.api.component.ManaPreferenceComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;
import org.ladysnake.cca.api.v3.entity.RespawnableComponent;

public class ManaPreferenceComponentInstance implements ManaPreferenceComponent, EntityComponentInitializer, RespawnableComponent<ManaPreferenceComponentInstance> {
    public static final ComponentKey<ManaPreferenceComponentInstance> MANA_PREFERENCE =
        ComponentRegistry.getOrCreate(class_2960.method_60655(Pentamana.MOD_NAMESPACE, "mana_preference"), ManaPreferenceComponentInstance.class);
    private boolean isEnbaled;

    public ManaPreferenceComponentInstance() {
    }

    public ManaPreferenceComponentInstance(class_1657 player) {
        this.isEnbaled = Pentamana.isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnbaled;
    }

    @Override
    public void setIsEnabled(boolean isEnabled) {
        this.isEnbaled = isEnabled;
    }

    @Override
    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        if (!nbtCompound.method_33133()) {
            this.isEnbaled = nbtCompound.method_10577("isEnbaled");
        }
    }

    @Override
    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10556("isEnbaled", this.isEnbaled);
    }

    @Override
    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(MANA_PREFERENCE, ManaPreferenceComponentInstance::new, RespawnCopyStrategy.ALWAYS_COPY);
    }
}
