package net.cookedseafood.pentamana.mana;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1259;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class ManaBar {
    protected float capacity;
    protected float supply;
    protected ManaBar.Position position;
    protected ManaTextual textual;
    protected boolean isVisible;
    protected class_1259.class_1260 color;
    protected class_1259.class_1261 style;

    public ManaBar(float capacity, float supply, ManaBar.Position position, ManaTextual textual, boolean isVisible, class_1259.class_1260 color, class_1259.class_1261 style) {
        this.capacity = capacity;
        this.supply = supply;
        this.position = position;
        this.textual = textual;
        this.isVisible = isVisible;
        this.color = color;
        this.style = style;
    }

    public boolean isFull() {
        return this.supply == capacity;
    }

    public boolean isEmpty() {
        return this.supply == 0.0f;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public void setCapacity(float capacity) {
        this.capacity = capacity;
    }

    public float getSupply() {
        return this.supply;
    }

    public void setSupply(float supply) {
        this.supply = supply;
    }

    public ManaBar.Position getPosition() {
        return this.position;
    }

    public void setPosition(ManaBar.Position position) {
        this.position = position;
    }

    public ManaTextual getTextual() {
        return this.textual;
    }

    public void setTextual(ManaTextual textual) {
        this.textual = textual;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public class_1259.class_1260 getColor() {
        return this.color;
    }

    public void setColor(class_1259.class_1260 color) {
        this.color = color;
    }

    public class_1259.class_1261 getStyle() {
        return this.style;
    }

    public void setStyle(class_1259.class_1261 style) {
        this.style = style;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaBar
     * 
     * @see #deepCopy()
     */
    public ManaBar copy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual, this.isVisible, this.color, this.style);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaBar
     * 
     * @see #copy()
     */
    public ManaBar deepCopy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual.deepCopy(), this.isVisible, this.color, this.style);
    }

    public static ManaBar fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new ManaBar(
            nbtCompound.method_10583("capacity"),
            nbtCompound.method_10583("supply"),
            ManaBar.Position.byName(nbtCompound.method_10558("position")),
            ManaTextual.fromNbt(nbtCompound.method_10562("textual"), wrapperLookup),
            nbtCompound.method_10577("isVisible"),
            class_1259.class_1260.method_5422(nbtCompound.method_10558("color")),
            class_1259.class_1261.method_5424(nbtCompound.method_10558("style"))
        );
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(
            new HashMap<>(
                Map.<String,class_2520>of(
                    "capacity",
                    class_2494.method_23244(this.capacity),
                    "supply",
                    class_2494.method_23244(this.supply),
                    "position",
                    class_2519.method_23256(this.position.name),
                    "textual",
                    this.textual.toNbt(wrapperLookup),
                    "isVisible",
                    class_2481.method_23234(this.isVisible),
                    "color",
                    class_2519.method_23256(this.color.method_5421()),
                    "style",
                    class_2519.method_23256(this.style.method_5425())
                )
            )
        );
    }

    public static enum Position {
        ACTIONBAR((byte)0, "actionbar"),
        BOSSBAR((byte)1, "bossbar"),
        SIDERBAR((byte)2, "siderbar");

        private byte index;
        private String name;

        Position(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static byte getIndex(String name) {
            return Arrays.stream(Position.values())
                .filter(manabarPosition -> manabarPosition.name.equals(name))
                .map(manabarPosition -> manabarPosition.index)
                .findAny()
                .orElse((byte)0);
        }

        public static String getName(byte index) {
            return Arrays.stream(Position.values())
                .filter(manabarPosition -> manabarPosition.index == index)
                .map(manabarPosition -> manabarPosition.name)
                .findAny()
                .orElse("");
        }

        public static Position byIndex(byte index) {
            return Arrays.stream(Position.values())
                .filter(manabarPosition -> manabarPosition.index == index)
                .findAny()
                .get();
        }

        public static Position byName(String name) {
            return Arrays.stream(Position.values())
                .filter(manabarPosition -> manabarPosition.name.equals(name))
                .findAny()
                .get();
        }
    }
}
