package net.cookedseafood.pentamana.mana;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ManaCharset {
    private List<List<class_2561>> charset;

    public ManaCharset(List<List<class_2561>> charset) {
        this.charset = charset;
    }

    public class_2561 toText() {
        class_5250 text = class_2561.method_43473();
        this.forEach(charType -> 
            charType.forEach(text::method_10852)
        );
        return text;
    }

    public List<List<class_2561>> getCharset() {
        return charset;
    }

    public void setCharset(List<List<class_2561>> charset) {
        this.charset = charset;
    }

    public int size() {
        return this.charset.size();
    }

    public boolean isEmpty() {
        return this.charset.isEmpty();
    }

    public boolean contains(List<class_2561> charType) {
        return this.charset.contains(charType);
    }

    public boolean containsAll(Collection<List<class_2561>> charTypes) {
        return this.containsAll(charTypes);
    }

    public List<class_2561> get(int index) {
        return this.charset.get(index);
    }

    public boolean add(List<class_2561> charType) {
        return this.charset.add(charType);
    }

    public void add(int i, List<class_2561> charType) {
        this.charset.add(i, charType);
    }

    public boolean addAll(Collection<List<class_2561>> charTypes) {
        return this.charset.addAll(charTypes);
    }

    public boolean addAll(int i, Collection<List<class_2561>> charTypes) {
        return this.charset.addAll(i, charTypes);
    }

    public boolean remove(List<class_2561> charType) {
        return this.charset.remove(charType);
    }

    public boolean removeAll(Collection<List<class_2561>> charTypes) {
        return this.charset.removeAll(charTypes);
    }

    public boolean removeIf(Predicate<? super List<class_2561>> filter) {
        return this.charset.removeIf(filter);
    }

    public void clear() {
        this.charset.clear();
    }

    public void forEach(Consumer<? super List<class_2561>> action) {
        this.charset.forEach(action);
    }

    public Iterator<List<class_2561>> iterator() {
        return this.charset.iterator();
    }

    public Stream<List<class_2561>> stream() {
        return this.charset.stream();
    }

    public void sort(Comparator<? super List<class_2561>> c) {
        this.charset.sort(c);
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaCharset
     * 
     * @see #deepCopy()
     */
    public ManaCharset copy() {
        return new ManaCharset(this.charset);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaCharset
     * 
     * @see #copy()
     */
    public ManaCharset deepCopy() {
        return new ManaCharset(this.stream()
            .map(type -> type.stream()
                .map(class_5250.class::cast)
                .map(class_5250::deepCopy)
                .collect(Collectors.toList())
            )
            .collect(Collectors.toList())
        );
    }

    public static ManaCharset fromNbt(class_2499 nbtList, class_7225.class_7874 wrapperLookup) {
        return new ManaCharset(
            nbtList.stream()
                .map(class_2499.class::cast)
                .map(manaCharacterType -> manaCharacterType.stream()
                    .map(class_2519.class::cast)
                    .map(class_2519::method_10714)
                    .map(manaCharacter -> class_2561.class_2562.method_10877(manaCharacter, wrapperLookup))
                    .map(class_2561.class::cast)
                    .collect(Collectors.toList())
                )
                .collect(Collectors.toList())
        );
    }

    public class_2499 toNbt(class_7225.class_7874 wrapperLookup) {
        return this.stream()
            .map(type -> type.stream()
                .map(character -> class_2561.class_2562.method_10867(character, wrapperLookup))
                .map(class_2519::method_23256)
                .collect(class_2499::new, class_2499::add, class_2499::addAll)
            )
            .collect(class_2499::new, class_2499::add, class_2499::addAll);
    }
}
