package net.cookedseafood.pentamana.mana;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ManaPattern {
    private List<class_2561> pattern;

    public ManaPattern(List<class_2561> pattern) {
        this.pattern = pattern;
    }

    public class_2561 toText() {
        class_5250 text = class_2561.method_43473();
        this.forEach(text::method_10852);
        return text;
    }

    public List<class_2561> getPattern() {
        return this.pattern;
    }

    public void setPattern(List<class_2561> pattern) {
        this.pattern = pattern;
    }

    public int size() {
        return this.pattern.size();
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public boolean contains(class_2561 text) {
        return this.pattern.contains(text);
    }

    public boolean containsAll(Collection<class_2561> texts) {
        return this.pattern.containsAll(texts);
    }

    public class_2561 get(int index) {
        return this.pattern.get(index);
    }

    public boolean add(class_2561 text) {
        return this.pattern.add(text);
    }

    public void add(int i, class_2561 text) {
        this.pattern.add(i, text);
    }

    public boolean addAll(Collection<class_2561> texts) {
        return this.pattern.addAll(texts);
    }

    public boolean addAll(int i, Collection<class_2561> texts) {
        return this.pattern.addAll(i, texts);
    }

    public boolean remove(class_2561 text) {
        return this.pattern.remove(text);
    }

    public boolean removeAll(Collection<class_2561> texts) {
        return this.pattern.removeAll(texts);
    }

    public boolean removeIf(Predicate<? super class_2561> filter) {
        return this.pattern.removeIf(filter);
    }

    public void clear() {
        this.pattern.clear();
    }

    public void forEach(Consumer<? super class_2561> action) {
        this.pattern.forEach(action);
    }

    public Iterator<class_2561> iterator() {
        return this.pattern.iterator();
    }

    public Stream<class_2561> stream() {
        return this.pattern.stream();
    }

    public void sort(Comparator<? super class_2561> c) {
        this.pattern.sort(c);
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaPattern
     * 
     * @see #deepCopy()
     */
    public ManaPattern copy() {
        return new ManaPattern(this.pattern);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaPattern
     * 
     * @see #copy()
     */
    public ManaPattern deepCopy() {
        return new ManaPattern(
            this.stream()
                .map(class_5250.class::cast)
                .map(class_5250::deepCopy)
                .collect(Collectors.toList())
        );
    }

    public static ManaPattern fromNbt(class_2499 nbtList, class_7225.class_7874 wrapperLookup) {
        return new ManaPattern(
            nbtList.stream()
                .map(class_2519.class::cast)
                .map(class_2519::method_10714)
                .map(text -> class_2561.class_2562.method_10877(text, wrapperLookup))
                .map(class_2561.class::cast)
                .collect(Collectors.toList())
        );
    }

    public class_2499 toNbt(class_7225.class_7874 wrapperLookup) {
        return this.stream()
            .map(text -> class_2561.class_2562.method_10867(text, wrapperLookup))
            .map(class_2519::method_23256)
            .collect(class_2499::new, class_2499::add, class_2499::addAll);
    }
}
