package net.cookedseafood.pentamana.mana;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.cookedseafood.pentamana.Pentamana;
import net.minecraft.class_124;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ManaRender {
    private ManaRender.Type type;
    private ManaCharset charset;
    private int pointsPerCharacter;
    private boolean isCompression;
    private byte compressionSize;

    public ManaRender(ManaRender.Type type, ManaCharset charset, int pointsPerCharacter, boolean isCompression, byte compressionSize) {
        this.type = type;
        this.charset = charset;
        this.pointsPerCharacter = pointsPerCharacter;
        this.isCompression = isCompression;
        this.compressionSize = compressionSize;
    }

    public class_2561 toText(float manaCapacity, float manaSupply) {
        return this.type == ManaRender.Type.CHARACTER ?
            this.toTextInCharacter(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.NUMERIC ?
            this.toTextInNumeric(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.PERCENTAGE ?
            this.toTextInPercentage(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.NONE ?
            this.toTextInNone() :
            class_2561.method_43473();
    }

    public class_2561 toTextInCharacter(float manaCapacity, float manaSupply) {
        int manaCapacityPoint = (int)(manaCapacity / Pentamana.manaPerPoint);
        int manaSupplyPoint = (int)(manaSupply / Pentamana.manaPerPoint);
        int manaCapacityPointTrimmed = manaCapacityPoint - manaCapacityPoint % pointsPerCharacter;
        int manaPointTrimmed = manaSupplyPoint - manaSupplyPoint % pointsPerCharacter;

        manaCapacityPointTrimmed = Math.min(manaCapacityPointTrimmed, Pentamana.manaPointLimit);

        class_5250 text = class_2561.method_43473();
        for (int manaPointIndex = 0; manaPointIndex < manaCapacityPointTrimmed; manaPointIndex += pointsPerCharacter) {
            int manaCharacterTypeIndex =
                manaPointIndex < manaPointTrimmed ?
                0 : manaPointIndex < manaSupplyPoint ?
                manaSupplyPoint - manaPointIndex : pointsPerCharacter;
            int manaCharacterIndex = manaPointIndex / pointsPerCharacter;

            class_2561 SelectedManaCharacter = this.charset.getCharset().get(manaCharacterTypeIndex).get(manaCharacterIndex);
            text.method_10852(SelectedManaCharacter);
        }

        return text;
    }

    public class_2561 toTextInNumeric(float manaCapacity, float manaSupply) {
        return class_2561.method_43470((int)(manaSupply / Pentamana.manaPerPoint) + "/" + (int)(manaCapacity / Pentamana.manaPerPoint)).method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
    }

    public class_2561 toTextInPercentage(float manaCapacity, float manaSupply) {
        return class_2561.method_43470((int)(manaSupply / manaCapacity * 100) + "%").method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
    }

    public class_2561 toTextInNone() {
        return class_2561.method_43473();
    }

    public ManaRender.Type getType() {
        return this.type;
    }

    public void setType(ManaRender.Type type) {
        this.type = type;
    }

    public ManaCharset getCharset() {
        return charset;
    }

    public void setCharset(ManaCharset charset) {
        this.charset = charset;
    }

    public int getPointsPerCharacter() {
        return pointsPerCharacter;
    }

    public void setPointsPerCharacter(int pointsPerCharacter) {
        this.pointsPerCharacter = pointsPerCharacter;
    }

    public boolean isCompression() {
        return this.isCompression;
    }

    public void setIsCompression(boolean isCompression) {
        this.isCompression = isCompression;
    }

    public byte getCompressionSize() {
        return this.compressionSize;
    }

    public void setCompressionSize(byte compressionSize) {
        this.compressionSize = compressionSize;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaRender
     * 
     * @see #deepCopy()
     */
    public ManaRender copy() {
        return new ManaRender(this.type, this.charset, this.pointsPerCharacter, this.isCompression, this.compressionSize);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaRender
     * 
     * @see #copy()
     */
    public ManaRender deepCopy() {
        return new ManaRender(this.type, this.charset.deepCopy(), this.pointsPerCharacter, this.isCompression, this.compressionSize);
    }

    public static ManaRender fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new ManaRender(
            ManaRender.Type.byName(nbtCompound.method_10558("type")),
            ManaCharset.fromNbt(nbtCompound.method_10554("charset", class_2520.field_33259), wrapperLookup),
            nbtCompound.method_10550("pointsPerCharacter"),
            nbtCompound.method_10577("isCompression"),
            nbtCompound.method_10571("compressionSize")
        );
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(
            new HashMap<>(
                Map.<String,class_2520>of(
                    "type",
                    class_2519.method_23256(this.type.name),
                    "charset",
                    this.charset.toNbt(wrapperLookup),
                    "pointsPerCharacter",
                    class_2497.method_23247(this.pointsPerCharacter),
                    "isCompression",
                    class_2481.method_23234(this.isCompression),
                    "compressionSize",
                    class_2481.method_23233(this.compressionSize)
                )
            )
        );
    }

    public static enum Type {
        CHARACTER((byte)1, "character"),
        NUMERIC((byte)2, "numeric"),
        PERCENTAGE((byte)3, "percentage"),
        NONE((byte)0, "none");
    
        private byte index;
        private String name;
    
        Type(byte index, String name) {
            this.index = index;
            this.name = name;
        }
    
        public byte getIndex() {
            return this.index;
        }
    
        public String getName() {
            return this.name;
        }
    
        public static byte getIndex(String name) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.name.equals(name))
                .map(manaManabarType -> manaManabarType.index)
                .findAny()
                .orElse((byte)0);
        }
    
        public static String getName(byte index) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.index == index)
                .map(manaManabarType -> manaManabarType.name)
                .findAny()
                .orElse("");
        }
    
        public static Type byIndex(byte index) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.index == index)
                .findAny()
                .get();
        }
    
        public static Type byName(String name) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.name.equals(name))
                .findAny()
                .get();
        }
    }
}
