/*
 * Decompiled with CFR 0.152.
 */
package net.cobra.lifesteal.enchantment.entity.effect;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9699;
import net.minecraft.class_9721;

public record LifeStealEnchantmentEntityEffect() implements class_9721
{
    public static final MapCodec<LifeStealEnchantmentEntityEffect> CODEC = MapCodec.unit((Object)new LifeStealEnchantmentEntityEffect());

    public void method_60220(class_3218 world, int level, class_9699 context, class_1297 user, class_243 pos) {
        if (!(user instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)user;
        Optional<class_1309> targetEntity = this.findAttackedEntity(world, pos);
        float baseDamage = (float)livingEntity.method_45325(class_5134.field_23721);
        float healAmount = this.getHealAmount(level, baseDamage, targetEntity);
        livingEntity.method_6025(healAmount);
    }

    private float getHealAmount(int level, float baseDamage, Optional<class_1309> targetEntity) {
        float healAmount = baseDamage * (0.1f * (float)level);
        if (targetEntity.isPresent()) {
            class_1309 target = targetEntity.get();
            healAmount = this.isPassiveMob(target) ? (healAmount *= 2.0f) : (healAmount *= 0.5f);
        }
        healAmount = Math.max(healAmount, 1.0f);
        return healAmount;
    }

    private Optional<class_1309> findAttackedEntity(class_3218 world, class_243 pos) {
        class_238 searchBox = new class_238(pos.field_1352 - 1.0, pos.field_1351 - 1.0, pos.field_1350 - 1.0, pos.field_1352 + 1.0, pos.field_1351 + 1.0, pos.field_1350 + 1.0);
        List entities = world.method_8390(class_1309.class, searchBox, e -> !e.method_7325());
        return entities.stream().findFirst();
    }

    private boolean isPassiveMob(class_1309 entity) {
        return entity.method_5864().method_5891().method_6136();
    }

    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }
}

