/*
 * Decompiled with CFR 0.152.
 */
package com.johnsmith.stopfistingtrees;

import com.johnsmith.stopfistingtrees.Config;
import com.mojang.logging.LogUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;

@Mod(value="stopfistingtrees")
public class stopfistingtrees {
    public static final String MODID = "stopfistingtrees";
    public static final Logger LOGGER = LogUtils.getLogger();

    public stopfistingtrees(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    @SubscribeEvent
    public void onBlockBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem;
        boolean hasRequiredTool;
        if (event.getState().is(BlockTags.LOGS) && !(hasRequiredTool = this.checkToolRequirement(heldItem = event.getEntity().getMainHandItem()))) {
            float multiplier = ((Double)Config.BREAK_SPEED_MULTIPLIER.get()).floatValue();
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @SubscribeEvent
    public void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack heldItem;
        boolean hasRequiredTool;
        if (event.getTargetBlock().is(BlockTags.LOGS) && !(hasRequiredTool = this.checkToolRequirement(heldItem = event.getEntity().getMainHandItem()))) {
            event.setCanHarvest(false);
        }
    }

    private boolean checkToolRequirement(ItemStack heldItem) {
        boolean isTool;
        if (heldItem.getItem() instanceof AxeItem) {
            return true;
        }
        boolean bl = isTool = heldItem.getItem() instanceof DiggerItem || heldItem.getItem() instanceof SwordItem;
        if (isTool) {
            return (Boolean)Config.TOOLS_BREAK_LOGS.get();
        }
        if (!heldItem.isEmpty()) {
            return (Boolean)Config.ITEMS_BREAK_LOGS.get();
        }
        return false;
    }
}

