package cn.sh1rocu.slashblade.mixin.common;

import cn.sh1rocu.slashblade.util.CommonHooks;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1706.class)
public abstract class AnvilMenuMixin extends class_4861 {
    @Shadow
    @Nullable
    private String itemName;
    @Unique
    private static final ThreadLocal<Float> sb$breakChance = new ThreadLocal<>();

    public AnvilMenuMixin(@Nullable class_3917<?> menuType, int i, class_1661 inventory, class_3914 containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method = "createResult", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal = 0), cancellable = true)
    private void sb$onAnvilUpdate(CallbackInfo ci, @Local(ordinal = 0) class_1799 itemStack, @Local(ordinal = 1) int j) {
        if (!itemStack.method_7960()) {
            if (!CommonHooks.onAnvilChange((class_1706) (Object) this, itemStack, this.field_22480.method_5438(1), field_22479, this.itemName, j, this.field_22482)) {
                ci.cancel();
            }
        }
    }

    @Inject(method = "onTake", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal = 0))
    private void sb$getForgeBreakChance(class_1657 player, class_1799 stack, CallbackInfo ci) {
        sb$breakChance.set(CommonHooks.onAnvilRepair(player, stack, this.field_22480.method_5438(0), this.field_22480.method_5438(1)));
    }

    @ModifyExpressionValue(method = "method_24922", at = @At(value = "CONSTANT", args = "floatValue=0.12"))
    private static float sb$useForgeBreakChanceIfPossible(float original) {
        if (original == 0.12f) {
            var value = sb$breakChance.get();
            sb$breakChance.remove();
            return value;
        }
        return original;
    }
}
