package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.event.RenderTickEvent;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2183;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class LockOnManager {
    private static final class SingletonHolder {
        private static final LockOnManager instance = new LockOnManager();
    }

    public static LockOnManager getInstance() {
        return SingletonHolder.instance;
    }

    private LockOnManager() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
    }

    public void onInputChange(InputCommandEvent event) {
        class_3222 player = event.getEntity();
        // set target
        class_1799 stack = event.getEntity().method_6047();
        if (stack.method_7960())
            return;
        if (!(stack.method_7909() instanceof ItemSlashBlade))
            return;

        class_1297 targetEntity;

        if (event.getOld().contains(InputCommand.SNEAK) == event.getCurrent().contains(InputCommand.SNEAK))
            return;

        if ((event.getOld().contains(InputCommand.SNEAK) && !event.getCurrent().contains(InputCommand.SNEAK))) {
            // remove target
            targetEntity = null;
        } else {
            // search target

            Optional<class_239> result = RayTraceHelper.rayTrace(player.method_37908(), player, player.method_5836(1.0f),
                    player.method_5720(), 40, 40, (e) -> true);
            Optional<class_1297> foundEntity = result.filter(r -> r.method_17783() == class_239.class_240.field_1331).filter(r -> {
                class_3966 er = (class_3966) r;
                class_1297 target = er.method_17782();

/*                if (target instanceof PartEntity) {
                    target = ((PartEntity<?>) target).getParent();
                }*/

                boolean isMatch = false;

                if (target instanceof class_1309)
                    isMatch = TargetSelector.lockon.method_18419(player, (class_1309) target);

                return isMatch;
            }).map(r -> ((class_3966) r).method_17782());

            if (foundEntity.isEmpty()) {
                List<class_1309> entities = player.method_37908().method_18466(class_1309.class,
                        TargetSelector.lockon, player, player.method_5829().method_1009(12.0D, 6.0D, 12.0D));

                foundEntity = entities.stream().map(s -> (class_1297) s)
                        .min(Comparator.comparingDouble(e -> e.method_5858(player)));
            }

/*            targetEntity = foundEntity.map(e -> (e instanceof PartEntity) ? ((PartEntity<?>) e).getParent() : e)
                    .orElse(null);*/
            targetEntity = foundEntity.orElse(null);

        }

        CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(
                s -> s.setTargetEntityId(targetEntity));

    }

    @Environment(EnvType.CLIENT)
    public static class Client {
        public static void onEntityUpdate(RenderTickEvent.Pre event) {
            final class_310 mcinstance = class_310.method_1551();
            if (mcinstance.field_1724 == null)
                return;

            class_746 player = mcinstance.field_1724;

            class_1799 stack = player.method_6047();
            if (stack.method_7960())
                return;

            CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(s -> {

                class_1297 target = s.getTargetEntity(player.method_37908());

                if (target == null)
                    return;
                if (!target.method_5805())
                    return;

                class_1309 entity = player;

                if (!entity.method_37908().method_8608())
                    return;
                if (CapabilityInputState.INPUT_STATE.maybeGet(entity)
                        .filter(input -> input.getCommands().contains(InputCommand.SNEAK)).isEmpty())
                    return;

                float partialTicks = mcinstance.method_1488();

                float oldYawHead = entity.field_6241;
                float oldYawOffset = entity.field_6283;
                float oldPitch = entity.method_36455();
                float oldYaw = entity.method_36454();

                float prevYawHead = entity.field_6259;
                float prevYawOffset = entity.field_6220;
                float prevYaw = entity.field_5982;
                float prevPitch = entity.field_6004;

                entity.method_5702(class_2183.class_2184.field_9851, target.method_19538().method_1031(0, target.method_5751() / 2.0, 0));

                float step = 0.125f * partialTicks;

                step *= Math.min(1.0f, Math.abs(class_3532.method_15393(oldYaw - entity.field_6241) * 0.5f));

                entity.method_36457(class_3532.method_17821(step, oldPitch, entity.method_36455()));
                entity.method_36456(class_3532.method_17821(step, oldYaw, entity.method_36454()));
                entity.method_5847(class_3532.method_17821(step, oldYawHead, entity.method_5791()));

                entity.field_6283 = oldYawOffset;

                entity.field_6220 = prevYawOffset;
                entity.field_6259 = prevYawHead;
                entity.field_5982 = prevYaw;
                entity.field_6004 = prevPitch;
            });
        }
    }
}
