package mods.flammpfeil.slashblade.client.renderer.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.ItemEntityRendererExtension;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.item.SwordType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_916;
import java.util.EnumSet;

@Environment(EnvType.CLIENT)
public class BladeItemEntityRenderer extends class_916 implements ItemEntityRendererExtension {
    public BladeItemEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public boolean sb$shouldSpreadItems() {
        return false;
    }

    @Override
    public boolean sb$shouldBob() {
        return false;
    }

    @Override
    public void method_3996(class_1542 itemIn, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                       class_4597 bufferIn, int packedLightIn) {
        this.field_4673 = 0;

        if (!itemIn.method_6983().method_7960()) {
            renderBlade(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            partialTicks = (float) (itemIn.field_7203 * 20.0 - (double) itemIn.method_6985());
            super.method_3996(itemIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderBlade(class_1542 itemIn, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                             class_4597 bufferIn, int packedLightIn) {
        if (itemIn instanceof BladeItemEntity bladeItem) {
            try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn)) {
                matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(entityYaw));

                class_1799 current = itemIn.method_6983();

                EnumSet<SwordType> types = SwordType.from(current);
                //itemIn.getPersistentData();
                ((EntityExtension) itemIn).sb$getPersistentData();
                class_2960 modelLocation = CapabilitySlashBlade.BLADESTATE.maybeGet(current)
                        .map((state) -> state.getModel().orElseGet(bladeItem::getModel)).orElseGet(bladeItem::getModel);
                class_2960 textureLocation = CapabilitySlashBlade.BLADESTATE.maybeGet(current)
                        .map((state) -> state.getTexture().orElseGet(bladeItem::getTexture))
                        .orElseGet(bladeItem::getTexture);

                WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);

                float scale = 0.00625f;

                try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix(matrixStackIn)) {

                    float heightOffset;
                    float xOffset = 0;
                    String renderTarget;
                    if (types.contains(SwordType.EDGEFRAGMENT)) {
                        heightOffset = 225;
                        xOffset = 200;
                        renderTarget = "blade_fragment";
                    } else if (types.contains(SwordType.BROKEN)) {
                        heightOffset = 100;
                        xOffset = 30;
                        renderTarget = "blade_damaged";
                    } else {
                        heightOffset = 225;
                        xOffset = 120;
                        renderTarget = "blade";
                    }

                    if (itemIn.method_5799()) {

                        matrixStackIn.method_46416(0, 0.025f, 0);
                        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(itemIn.field_7203));

                        matrixStackIn.method_22905(scale, scale, scale);

                        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(90));

                    } else if (!itemIn.method_24828()) {
                        matrixStackIn.method_22905(scale, scale, scale);

                        float speed = -81f;
                        matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(speed * (itemIn.field_6012 + partialTicks)));
                        matrixStackIn.method_46416(xOffset, 0, 0);
                    } else {
                        matrixStackIn.method_22905(scale, scale, scale);

                        matrixStackIn
                                .method_22907(class_7833.field_40718.rotationDegrees(60 + (float) Math.toDegrees(itemIn.field_7203 / 6.0)));
                        matrixStackIn.method_46416(heightOffset, 0, 0);
                    }

                    BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn,
                            bufferIn, packedLightIn);
                    BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous",
                            textureLocation, matrixStackIn, bufferIn, packedLightIn);
                }

                if (itemIn.method_5799() || itemIn.method_24828() && !types.contains(SwordType.NOSCABBARD)) {

                    try (MSAutoCloser msac2 = MSAutoCloser.pushMatrix(matrixStackIn)) {

                        matrixStackIn.method_46416(0, 0.025f, 0);

                        matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(itemIn.field_7203));

                        if (!itemIn.method_5799()) {
                            matrixStackIn.method_22904(0.75, 0, -0.4);
                        }

                        matrixStackIn.method_22905(scale, scale, scale);

                        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(90));

                        String renderTarget = "sheath";

                        BladeRenderState.renderOverrided(current, model, renderTarget, textureLocation, matrixStackIn,
                                bufferIn, packedLightIn);
                        BladeRenderState.renderOverridedLuminous(current, model, renderTarget + "_luminous",
                                textureLocation, matrixStackIn, bufferIn, packedLightIn);
                    }
                }

            }
        }
        // todo: fire render override?
    }

    /*
     * @Override public void doRenderShadowAndFire(Entity entityIn, double x, double
     * y, double z, float yaw, float partialTicks) {
     *
     * matrixStackIn.enableBlend(); matrixStackIn.blendFuncSeparate(
     * matrixStackIn.SourceFactor.SRC_COLOR, matrixStackIn.DestFactor.ONE ,
     * matrixStackIn.SourceFactor.ONE, matrixStackIn.DestFactor.ZERO);
     *
     * matrixStackIn.pushMatrix(); matrixStackIn.translatef((float)x, (float)y,
     * (float)z); matrixStackIn.scaled(1.4,1.8, 1.4);
     * matrixStackIn.translatef((float)-x, (float)-y, (float)-z);
     *
     * //core super.doRenderShadowAndFire(entityIn, x, y, z, yaw, partialTicks);
     *
     *
     * //dark fire matrixStackIn.blendFuncSeparate(
     * matrixStackIn.SourceFactor.SRC_ALPHA, matrixStackIn.DestFactor.ONE ,
     * matrixStackIn.SourceFactor.ONE, matrixStackIn.DestFactor.ZERO);
     * matrixStackIn.translatef((float)x, (float)y, (float)z);
     * matrixStackIn.scaled(1.5,1.6,1.5); matrixStackIn.translatef((float)-x,
     * (float)-y, (float)-z); super.doRenderShadowAndFire(entityIn, x, y, z, yaw,
     * partialTicks); matrixStackIn.blendEquation(GL14.GL_FUNC_REVERSE_SUBTRACT);
     * super.doRenderShadowAndFire(entityIn, x, y, z, yaw, partialTicks);
     *
     *
     * matrixStackIn.popMatrix(); matrixStackIn.blendEquation(GL14.GL_FUNC_ADD);
     * matrixStackIn.blendFuncSeparate(GL11.GL_SRC_ALPHA,
     * GL11.GL_ONE_MINUS_SRC_ALPHA, GL11.GL_ONE, GL11.GL_ZERO);
     * matrixStackIn.disableBlend(); }
     */
}
