package mods.flammpfeil.slashblade.client.renderer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1060;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(EnvType.CLIENT)
public class RankRenderer {
    private static final class SingletonHolder {
        private static final RankRenderer instance = new RankRenderer();
    }

    public static RankRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private RankRenderer() {
    }

    public void register() {
        HudRenderCallback.EVENT.register(this::renderTick);
    }

    static class_2960 RankImg = new class_2960(SlashBlade.MODID, "textures/gui/rank.png");

    @Environment(EnvType.CLIENT)
    public void renderTick(class_332 drawContext, float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null)
            return;
        // if(!mc.isGameFocused()) return;
        if (!class_310.method_1498())
            return;
        if (mc.field_1755 != null) {
            if (!(mc.field_1755 instanceof class_408))
                return;
        }

        class_746 player = mc.field_1724;
        long time = System.currentTimeMillis();

        renderRankHud(tickDelta, player, time);
    }

    private void renderRankHud(Float partialTicks, class_746 player, long time) {
        class_310 mc = class_310.method_1551();

        CapabilityConcentrationRank.RANK_POINT.maybeGet(player).ifPresent(cr -> {
            long now = player.method_37908().method_8510();

            IConcentrationRank.ConcentrationRanks rank = cr.getRank(now);

            /*
             * debug rank = IConcentrationRank.ConcentrationRanks.C; now =
             * cr.getLastUpdate();
             */

            if (rank == IConcentrationRank.ConcentrationRanks.NONE)
                return;

            // todo : korenani loadGUIRenderMatrix
            // mc.getMainWindow().loadGUIRenderMatrix(Minecraft.IS_RUNNING_ON_MAC);

            int k = mc.method_22683().method_4486();
            int l = mc.method_22683().method_4502();

            class_4587 poseStack = new class_4587();
            // position
            poseStack.method_46416(k * 2 / 3, l / 5, 0);

            // RenderSystem.enableTexture();
            RenderSystem.disableDepthTest();
            class_1060 texturemanager = class_310.method_1551().method_1531();
            texturemanager.method_4619(RankImg).method_4527(false, false);
            RenderSystem.setShaderTexture(0, RankImg);

            boolean showTextRank = false;

            long textTimeout = cr.getLastRankRise() + 20;
            long visibleTimeout = cr.getLastUpdate() + 120;

            if (now < textTimeout)
                showTextRank = true;

            if (now < visibleTimeout) {
                int rankOffset = 32 * (rank.level - 1);
                int textOffset = showTextRank ? 128 : 0;

                int progress = (int) (33 * cr.getRankProgress(now));

                int progressIcon = (int) (18 * cr.getRankProgress(now));
                int progressIconInv = 17 - progressIcon;

                // GL11.glScalef(3,3,3);
                // iconFrame
                drawTexturedQuad(poseStack, 0, 0, 0 + textOffset + 64, rankOffset, 64, 32, -95f);
                // icon
                drawTexturedQuad(poseStack, 0, progressIconInv + 7, 0 + textOffset, rankOffset + progressIconInv + 7,
                        64, progressIcon, -90f);

                // gauge frame
                drawTexturedQuad(poseStack, 0, 32, 0, 256 - 16, 64, 16, -90f);
                // gause fill
                drawTexturedQuad(poseStack, 16, 32, 16, 256 - 32, progress, 16, -95f);
            }

        });

    }

    public static void drawTexturedQuad(class_4587 poseStack, int x, int y, int u, int v, int width, int height,
                                        float zLevel) {
        float var7 = 0.00390625F; // 1/256 texturesize
        float var8 = 0.00390625F;
        RenderSystem.setShader(class_757::method_34542);

        class_289 tessellator = class_289.method_1348();
        class_287 wr = tessellator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);

        Matrix4f m = poseStack.method_23760().method_23761();

        wr.method_22918(m, x + 0, y + height, zLevel).method_22913((u + 0.0f) * var7, (v + height) * var8).method_1344();
        wr.method_22918(m, x + width, y + height, zLevel).method_22913((u + width) * var7, (v + height) * var8).method_1344();
        wr.method_22918(m, x + width, y + 0, zLevel).method_22913((u + width) * var7, (v + 0) * var8).method_1344();
        wr.method_22918(m, x + 0, y + 0, zLevel).method_22913((u + 0) * var7, (v + 0) * var8).method_1344();

        // tessellator.end();
        class_286.method_43433(wr.method_1326());
    }
}
