package mods.flammpfeil.slashblade.event.client;

import cn.sh1rocu.slashblade.mixin.accessor.AdvancementTabAccessor;
import cn.sh1rocu.slashblade.mixin.accessor.AdvancementWidgetAccessor;
import cn.sh1rocu.slashblade.mixin.accessor.AdvancementsScreenAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import mods.flammpfeil.slashblade.SlashBlade;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2952;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_454;
import net.minecraft.class_456;
import net.minecraft.class_457;
import net.minecraft.class_4587;
import net.minecraft.class_505;
import net.minecraft.class_5455;
import net.minecraft.class_8060;
import net.minecraft.world.item.crafting.*;
import java.util.*;

public class AdvancementsRecipeRenderer implements class_2952<class_1856> {

    private static final class_310 MCINSTANCE = class_310.method_1551();
    private static final class_2960 GUI_TEXTURE_CRAFTING_TABLE = new class_2960(
            "textures/gui/container/crafting_table.png");
    private static final class_2960 GUI_TEXTURE_FURNACE = new class_2960(
            "textures/gui/container/furnace.png");
    private static final class_2960 GUI_TEXTURE_BLAST_FURNACE = new class_2960(
            "textures/gui/container/blast_furnace.png");
    private static final class_2960 GUI_TEXTURE_SMOKER = new class_2960(
            "textures/gui/container/smoker.png");
    private static final class_2960 GUI_TEXTURE_SMITHING = new class_2960(
            "textures/gui/container/smithing.png");
    private static final class_2960 GUI_TEXTURE_ANVIL = new class_2960("textures/gui/container/anvil.png");

    private static final class SingletonHolder {
        private static final AdvancementsRecipeRenderer instance = new AdvancementsRecipeRenderer();
    }

    public static AdvancementsRecipeRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private AdvancementsRecipeRenderer() {
    }

    public void register() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            this.onInitGuiPost(client, screen, scaledWidth, scaledHeight);
            ScreenEvents.afterRender(screen).register(this::onDrawScreenPost);
        });
    }


    public static class_505 gr = new class_505();

    public static class_2960 currentRecipe = null;

    static final class_3956<DummyAnvilRecipe> dummy_anvilType = new class_3956<DummyAnvilRecipe>() {
        public String toString() {
            return "sb_forgeing";
        }
    };
    /* RecipeType.register("sb_forgeing"); */

    static RecipeView currentView = null;
    static Map<class_3956<?>, RecipeView> typeRecipeViewMap = createRecipeViewMap();

    static class DummyAnvilRecipe implements class_1860<class_1263> {
        protected class_8060 original;
        private final class_1799 result;
        private final class_2960 recipeId;

        class_2371<class_1856> nonnulllist = class_2371.method_10213(2, class_1856.field_9017);

        public DummyAnvilRecipe(class_8060 recipe) {
            original = recipe;

            class_2540 pb = new class_2540(Unpooled.buffer());
            class_8060.class_8061 ss = new class_8060.class_8061();
            ss.method_48457(pb, original);

            class_1856.method_8086(pb);
            nonnulllist.set(0, class_1856.method_8086(pb));
            nonnulllist.set(1, class_1856.method_8086(pb));

            result = pb.method_10819();

            this.recipeId = original.method_8114();
        }

        @Override
        public boolean method_8115(class_1263 inv, class_1937 worldIn) {
            return false;
        }

        @Override
        public class_1799 method_8116(class_1263 p_44001_, class_5455 p_267165_) {
            return result.method_7972();
        }

        @Override
        public boolean method_8113(int width, int height) {
            return false;
        }

        @Override
        public class_1799 method_8110(class_5455 p_267052_) {
            return result;
        }

        @Override
        public class_2371<class_1856> method_8117() {
            return nonnulllist;
        }

        @Override
        public class_1799 method_17447() {
            return new class_1799(class_2246.field_10535);
        }

        @Override
        public class_2960 method_8114() {
            return this.recipeId;
        }

        @Override
        public class_1865<?> method_8119() {
            return null;
        }

        @Override
        public class_3956<?> method_17716() {
            return dummy_anvilType;
        }
    }

    static class DummySmithingRecipe extends DummyAnvilRecipe {
        public DummySmithingRecipe(class_8060 recipe) {
            super(recipe);
        }

        @Override
        public class_1799 method_17447() {
            return original.method_17447();
        }

        @Override
        public class_3956<?> method_17716() {
            return original.method_17716();
        }
    }

    static class_1860<?> overrideDummyRecipe(class_1860<?> original) {

        if (!(original instanceof class_8060))
            return original;

        if (original.method_8114().method_12832().startsWith("anvilcrafting")) {
            return new DummyAnvilRecipe((class_8060) original);
        } else {
            return new DummySmithingRecipe((class_8060) original);
        }
    }

    public static class RecipeView {
        final class_3956<?> recipeType;
        final class_2960 background;
        List<class_2382> slots = Lists.newArrayList();
        final boolean isWideOutputSlot;

        public RecipeView(class_3956<?> recipeType, class_2960 background, List<class_2382> slots) {
            this(recipeType, background, slots, true);
        }

        public RecipeView(class_3956<?> recipeType, class_2960 background, List<class_2382> slots,
                          boolean isWideOutputSlot) {
            this.recipeType = recipeType;
            this.background = background;
            this.slots = slots;
            this.isWideOutputSlot = isWideOutputSlot;
        }
    }

    static Map<class_3956<?>, RecipeView> createRecipeViewMap() {
        Map<class_3956<?>, RecipeView> map = Maps.newHashMap();

        {
            List<class_2382> list = Lists.newArrayList();

            // output
            list.add(new class_2382(124, 35, 0));

            // grid
            int SlotMargin = 18;
            int LeftMargin = 30;
            int TopMargin = 17;

            int RecipeGridX = 3;
            int RecipeGridY = 3;

            for (int i = 0; i < RecipeGridX; ++i) {
                for (int j = 0; j < RecipeGridY; ++j) {
                    list.add(new class_2382(LeftMargin + j * SlotMargin, TopMargin + i * SlotMargin, 0));
                }
            }

            class_3956<?> key = class_3956.field_17545;
            map.put(key, new RecipeView(key, GUI_TEXTURE_CRAFTING_TABLE, list));
        }

        {
            List<class_2382> list = Lists.newArrayList();

            // output
            list.add(new class_2382(116, 35, 0));
            // input
            list.add(new class_2382(56, 17, 0));
            // fuel
            list.add(new class_2382(56, 53, 0));

            {
                class_3956<?> key = class_3956.field_17546;
                map.put(key, new RecipeView(key, GUI_TEXTURE_FURNACE, list));
            }
            {
                class_3956<?> key = class_3956.field_17547;
                map.put(key, new RecipeView(key, GUI_TEXTURE_BLAST_FURNACE, list));
            }
            {
                class_3956<?> key = class_3956.field_17548;
                map.put(key, new RecipeView(key, GUI_TEXTURE_SMOKER, list));
            }
        }

        {
            List<class_2382> list = Lists.newArrayList();

            // output
            list.add(new class_2382(134, 47, 0));

            // input
            list.add(new class_2382(27, 47, 0));
            // material
            list.add(new class_2382(76, 47, 0));

            {
                class_3956<?> key = class_3956.field_25388;
                map.put(key, new RecipeView(key, GUI_TEXTURE_SMITHING, list, false));
            }

            {
                class_3956<?> key = dummy_anvilType;
                map.put(key, new RecipeView(key, GUI_TEXTURE_ANVIL, list, false));
            }
        }

        return map;
    }

    @Override
    public void method_12815(Iterator<class_1856> ingredients, int slotIn, int maxAmount, int y, int x) {
        class_1856 ingredient = ingredients.next();
        if (!ingredient.method_8103()) {
            if (slotIn < currentView.slots.size()) {

                class_2382 slot = currentView.slots.get(slotIn);
                gr.method_2569(ingredient, slot.method_10263(), slot.method_10264());
            }
        }
    }

    static void clearGhostRecipe() {
        gr.method_2571();
        currentRecipe = null;
        currentView = null;
    }

    static void setGhostRecipe(class_1799 icon) {
        if (icon == null || !(icon.method_7985() && icon.method_7969().method_10545("Crafting"))) {
            clearGhostRecipe();
            return;
        }
        getInstance().setGhostRecipe(new class_2960(icon.method_7969().method_10558("Crafting")));
    }

    void setGhostRecipe(class_2960 loc) {
        if (Objects.equals(loc, currentRecipe)) return;
        currentRecipe = loc;//减少性能消耗
        Optional<? extends class_1860<?>> recipe = MCINSTANCE.field_1687.method_8433().method_8130(loc);
        if (!recipe.isPresent()) {
            SlashBlade.LOGGER.warn("[Achievement Recipe Render] Recipe does not exist: {}", loc);
            clearGhostRecipe();
            return;
        }

        gr.method_2571();
        class_1860<?> iRecipe = recipe.get();
        iRecipe = overrideDummyRecipe(iRecipe);
        gr.method_2565(iRecipe);
        currentView = typeRecipeViewMap.get(iRecipe.method_17716());
        if (currentView == null || currentView.slots.size() <= 0) {
            SlashBlade.LOGGER.warn("[Achievement Recipe Render] The GUI display of the current recipe type is not supported: {}", iRecipe.method_17716());
            clearGhostRecipe();
            return;
        }

        final int outputslotIndex = 0;
        class_2382 outputSlot = currentView.slots.get(outputslotIndex);
        gr.method_2569(class_1856.method_8101(iRecipe.method_8110(null)), outputSlot.method_10263(), outputSlot.method_10264());
        this.method_12816(3, 3, outputslotIndex, iRecipe, iRecipe.method_8117().iterator(), 1);
    }

    void drawBackGround(class_332 gg, int xCorner, int yCorner, int zOffset, int xSize, int ySize, int yClip) {
        int bPadding = 5;
        gg.method_25291(currentView.background, xCorner, yCorner, zOffset, 0, 0, xSize, yClip - bPadding, 256, 256);
        gg.method_25291(currentView.background, xCorner, yCorner + yClip - bPadding, zOffset, 0, ySize - bPadding, xSize,
                bPadding, 256, 256);
    }

    void drawGhostRecipe(class_332 gg, int xCorner, int yCorner, int zOffset, float partialTicks) {
        try {
            gg.method_51448().method_22903();
            // matrixStack.translate(0,0,zOffset);

            /*
             * ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
             *
             * float tmp = ir.blitOffset; ir.blitOffset = zOffset - 125;
             */
            int padding = 5;
            gg.method_51445(gr.method_2566().method_17447(), xCorner + padding, yCorner + padding);

            boolean wideOutputSlot = currentView.isWideOutputSlot;

            gr.method_2567(gg, MCINSTANCE, xCorner, yCorner, wideOutputSlot, partialTicks);

            // ir.blitOffset = tmp;

        } finally {
            gg.method_51448().method_22909();
        }
    }

    void drawTooltip(class_332 gg, int xCorner, int yCorner, int zOffset, int mouseX, int mouseY, class_437 gui) {

        class_1799 itemStack = null;

        int slotSize = 16;

        for (int i = 0; i < gr.method_2572(); ++i) {
            class_505.class_506 ghostIngredient = gr.method_2570(i);
            int j = ghostIngredient.method_2574() + xCorner;
            int k = ghostIngredient.method_2575() + yCorner;
            if (mouseX >= j && mouseY >= k && mouseX < j + slotSize && mouseY < k + slotSize) {
                itemStack = ghostIngredient.method_2573();
            }
        }

        if (itemStack != null) {
            if (itemStack != null && MCINSTANCE.field_1755 != null) {
                gg.method_51446(MCINSTANCE.field_1772, itemStack, mouseX, mouseY);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void onDrawScreenPost(class_437 screen, class_332 drawContext, int mouseX, int mouseY, float tickDelta) {
        if (!(screen instanceof class_457))
            return;
        if (AdvancementsRecipeRenderer.currentRecipe == null)
            return;
        if (AdvancementsRecipeRenderer.currentView == null)
            return;

        class_457 gui = (class_457) screen;

        try {

            drawContext.method_51448().method_22903();

            class_4587 matrixStack = drawContext.method_51448();

            int zOffset = 425;
            int zStep = 75;
            matrixStack.method_46416(0, 0, zOffset);

            int xSize = 176;
            int ySize = 166;
            int yClip = 85;

            int xCorner = (gui.field_22789 - xSize) / 2;
            int yCorner = (gui.field_22790 - yClip) / 2;

            drawBackGround(drawContext, xCorner, yCorner, zOffset, xSize, ySize, yClip);

            drawGhostRecipe(drawContext, xCorner, yCorner, zOffset, tickDelta);

            matrixStack.method_46416(0, 0, zStep);
            drawTooltip(drawContext, xCorner, yCorner, zOffset, mouseX, mouseY, gui);

        } finally {
            drawContext.method_51448().method_22909();
        }
    }

    @SuppressWarnings("unchecked")
    @Environment(EnvType.CLIENT)
    public void onInitGuiPost(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_457))
            return;

        class_457 gui = (class_457) screen;
        ((List<class_364>) gui.method_25396()).add(new AdvancementsExGuiEventListener(gui));
    }

    public static class AdvancementsExGuiEventListener implements class_364 {
        class_457 screen;

        public AdvancementsExGuiEventListener(class_457 screen) {
            this.screen = screen;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 1) {
                clearGhostRecipe();
                return false;
            }

            int offsetX = (screen.field_22789 - 252) / 2;
            int offsetY = (screen.field_22790 - 140) / 2;

            class_1799 found = null;

            class_454 selectedTab = ((AdvancementsScreenAccessor) screen).sb$getSelectedTab();

            if (selectedTab == null)
                return false;

            int mouseXX = (int) (mouseX - offsetX - 9);
            int mouseYY = (int) (mouseY - offsetY - 18);

            double scrollX = ((AdvancementTabAccessor) selectedTab).sb$getScrollX();
            double scrollY = ((AdvancementTabAccessor) selectedTab).sb$getScrollY();
            Map<class_161, class_456> guis = ((AdvancementTabAccessor) selectedTab).sb$getWidgets();

            int i = class_3532.method_15357(scrollX);
            int j = class_3532.method_15357(scrollY);
            if (mouseXX > 0 && mouseXX < 234 && mouseYY > 0 && mouseYY < 113) {
                for (class_456 advancemententrygui : guis.values()) {
                    if (advancemententrygui.method_2329(i, j, mouseXX, mouseYY)) {

                        class_185 info = ((AdvancementWidgetAccessor) advancemententrygui).sb$getDisplay();

                        found = info.method_821();

                        break;
                    }
                }
            }

            setGhostRecipe(found);

            return false;
        }

        boolean focus = false;

        @Override
        public void method_25365(boolean p_265728_) {
            focus = p_265728_;
        }

        @Override
        public boolean method_25370() {
            return focus;
        }
    }
}
