package mods.flammpfeil.slashblade.slasharts;

import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class SakuraEnd {
    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute,
                                            boolean critical, double damage) {
        return doSlash(playerIn, roll, centerOffset, mute, critical, damage, KnockBacks.cancel);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute,
                                            boolean critical, double damage, KnockBacks knockback) {

        int colorCode = CapabilitySlashBlade.BLADESTATE.maybeGet(playerIn.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);

        return doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, damage, knockback);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, int colorCode, class_243 centerOffset,
                                            boolean mute, boolean critical, double damage, KnockBacks knockback) {

        if (playerIn.method_37908().method_8608())
            return null;

        class_243 pos = playerIn.method_19538().method_1031(0.0D, (double) playerIn.method_5751() * 0.75D, 0.0D)
                .method_1019(playerIn.method_5720().method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, playerIn.method_5705(0)).method_1021(centerOffset.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, playerIn.method_5705(0) + 90).method_1021(centerOffset.field_1350))
                .method_1019(playerIn.method_5720().method_1021(centerOffset.field_1350));

        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, playerIn.method_37908());

        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432(playerIn);
        jc.setRotationRoll(roll);
        jc.method_36456(playerIn.method_36454());
        jc.method_36457(0);

        jc.setColor(colorCode);

        jc.setMute(mute);
        jc.setIsCritical(critical);

        jc.setDamage(damage);

        jc.setKnockBack(knockback);

        if (playerIn != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(playerIn)
                    .ifPresent(rank -> jc.setRank(rank.getRankLevel(playerIn.method_37908().method_8510())));

        playerIn.method_37908().method_8649(jc);

        return jc;
    }
}
