package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import java.util.List;

public class ArrowReflector {

    public static boolean isMatch(class_1297 arrow, class_1297 attacker) {
        if (arrow == null)
            return false;
        if (!(arrow instanceof class_1676))
            return false;

        return true;
    }

    public static void doReflect(class_1297 arrow, class_1297 attacker) {
        if (!isMatch(arrow, attacker))
            return;

        arrow.field_6037 = true;
        if (attacker != null) {
            class_243 dir = attacker.method_5720();

            do {
                if (attacker instanceof class_1309)
                    break;

                class_1799 stack = ((class_1309) attacker).method_6047();

                if (stack.method_7960())
                    break;
                if (!(stack.method_7909() instanceof ItemSlashBlade))
                    break;

                class_1297 target = CapabilitySlashBlade.BLADESTATE.maybeGet(stack)
                        .map(s -> s.getTargetEntity(attacker.method_37908())).orElse(null);
                if (target != null) {
                    dir = arrow.method_19538().method_1020(target.method_5836(1.0f)).method_1029();
                } else {
                    dir = arrow.method_19538()
                            .method_1020(attacker.method_5720().method_1021(10).method_1019(attacker.method_5836(1.0f))).method_1029();
                }

            } while (false);

            ((class_1676) arrow).method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 3.5f, 0.2f);

            if (arrow instanceof class_1665)
                ((class_1665) arrow).method_7439(true);

        }
    }

    public static void doTicks(class_1309 attacker) {

        class_1799 stack = attacker.method_6047();

        if (stack.method_7960())
            return;
        if (!(stack.method_7909() instanceof ItemSlashBlade))
            return;

        CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(s -> {
            int ticks = attacker.method_6048();

            if (ticks == 0)
                return;

            class_2960 old = s.getComboSeq();
            class_2960 current = s.resolvCurrentComboState(attacker);
            ComboState currentCS = ComboStateRegistry.COMBO_STATE.method_10223(current) != null
                    ? ComboStateRegistry.COMBO_STATE.method_10223(current)
                    : ComboStateRegistry.NONE;
            if (old != current) {
                ComboState oldCS = ComboStateRegistry.COMBO_STATE.method_10223(current);
                ticks -= (int) TimeValueHelper.getTicksFromMSec(oldCS.getTimeoutMS());
            }

            double period = TimeValueHelper.getTicksFromFrames(currentCS.getEndFrame() - currentCS.getStartFrame())
                    * (1.0f / currentCS.getSpeed());

            if (ticks < period) {
                List<class_1297> founds = TargetSelector.getReflectableEntitiesWithinAABB(attacker);

                founds.stream().filter(e -> (e instanceof class_1676) && ((class_1676) e).method_24921() != attacker)
                        .forEach(e -> doReflect(e, attacker));
            }
        });

    }

}
