package mods.flammpfeil.slashblade.event.bladestand;

import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import javax.annotation.Nullable;

public class CopySpecialEffectFromBladeEvent extends SlashBladeEvent {
    private final class_2960 SEKey;
    private final boolean isRemovable;
    private final boolean isCopiable;
    private final BladeStandAttackEvent originalEvent;
    private final class_1799 orb;
    private final class_1542 itemEntity;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onCopySpecialEffect(event);
        }
    });

    public CopySpecialEffectFromBladeEvent(class_1799 blade, ISlashBladeState state, class_2960 SEKey,
                                           BladeStandAttackEvent originalEvent, boolean isRemovable, boolean isCopiable,
                                           class_1799 orb, class_1542 itemEntity) {
        super(blade, state);
        this.SEKey = SEKey;
        this.isRemovable = isRemovable;
        this.isCopiable = isCopiable;
        this.originalEvent = originalEvent;
        this.orb = orb;
        this.itemEntity = itemEntity;
    }

    public CopySpecialEffectFromBladeEvent(PreCopySpecialEffectFromBladeEvent pe, class_1799 orb,
                                           class_1542 itemEntity) {
        this(pe.getBlade(), pe.getSlashBladeState(), pe.getSEKey(), pe.getOriginalEvent(), pe.isRemovable(),
                pe.isCopiable(), orb, itemEntity);
    }

    public class_2960 getSEKey() {
        return SEKey;
    }

    public @Nullable BladeStandAttackEvent getOriginalEvent() {
        return originalEvent;
    }

    public boolean isRemovable() {
        return isRemovable;
    }

    public boolean isCopiable() {
        return isCopiable;
    }

    public class_1799 getOrb() {
        return orb;
    }

    public class_1542 getItemEntity() {
        return itemEntity;
    }

    public interface Callback {
        void onCopySpecialEffect(CopySpecialEffectFromBladeEvent event);
    }
}
