package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.LivingFallEvent;
import cn.sh1rocu.slashblade.api.event.PlayerFlyableFallEvent;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class FallHandler {
    private static final class SingletonHolder {
        private static final FallHandler instance = new FallHandler();
    }

    public static FallHandler getInstance() {
        return SingletonHolder.instance;
    }

    public void register() {
        LivingFallEvent.CALLBACK.register(this::onFall);
        PlayerFlyableFallEvent.CALLBACK.register(this::onFlyableFall);
    }

    public void onFall(LivingFallEvent event) {
        resetState(event.getEntity());
    }

    public void onFlyableFall(PlayerFlyableFallEvent event) {
        resetState(event.getEntity());
    }

    public static void resetState(class_1309 user) {
        CapabilitySlashBlade.BLADESTATE.maybeGet(user.method_6047()).ifPresent(
                state -> {
                    state.setFallDecreaseRate(0);

                    ComboState combo = ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) != null
                            ? ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq())
                            : ComboStateRegistry.NONE;
                    if (combo.isAerial()) {
                        state.setComboSeq(combo.getNextOfTimeout(user));
                    }
                });

    }

    public static void spawnLandingParticle(class_1309 user, float fallFactor) {
        if (!user.method_37908().method_8608()) {
            int x = class_3532.method_15357(user.method_23317());
            int y = class_3532.method_15357(user.method_23318() - (double) 0.5F);
            int z = class_3532.method_15357(user.method_23321());
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = user.method_37908().method_8320(pos);

            float f = (float) class_3532.method_15386(fallFactor);
            if (!state.method_26215()) {
                double d0 = Math.min(0.2F + f / 15.0F, 2.5D);
                int i = (int) (150.0D * d0);
                //if (!state.addLandingEffects((ServerLevel) user.level(), pos, state, user, i))
                ((class_3218) user.method_37908()).method_14199(new class_2388(class_2398.field_11217, state),
                        user.method_23317(), user.method_23318(), user.method_23321(), i, 0.0D, 0.0D, 0.0D, 0.15F);
            }
        }
    }

    public static void spawnLandingParticle(class_1297 user, class_243 targetPos, class_243 normal, float fallFactor) {
        if (!user.method_37908().method_8608()) {

            class_243 blockPos = targetPos.method_1019(normal.method_1029().method_1021(0.5f));

            int x = class_3532.method_15357(blockPos.method_10216());
            int y = class_3532.method_15357(blockPos.method_10214());
            int z = class_3532.method_15357(blockPos.method_10215());
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = user.method_37908().method_8320(pos);

            float f = (float) class_3532.method_15386(fallFactor);
            if (!state.method_26215()) {
                double d0 = Math.min(0.2F + f / 15.0F, 2.5D);
                int i = (int) (150.0D * d0);
                ((class_3218) user.method_37908()).method_14199(new class_2388(class_2398.field_11217, state),
                        targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), i, 0.0D, 0.0D, 0.0D, 0.15F);
            }
        }
    }

    public static void fallDecrease(class_1309 user) {
        if (!user.method_5740() && !user.method_24828()) {
            user.field_6017 = 1;

            float currentRatio = CapabilitySlashBlade.BLADESTATE.maybeGet(user.method_6047()).map((state) -> {
                float decRatio = state.getFallDecreaseRate();

                float newDecRatio = decRatio + 0.05f;
                newDecRatio = Math.min(1.0f, newDecRatio);
                state.setFallDecreaseRate(newDecRatio);

                return decRatio;
            }).orElseGet(() -> 1.0f);

            double gravityReductionFactor = 0.85f;

            int level = class_1890.method_8225(class_1893.field_9129, user.method_6047());
            if (level > 0) {
                gravityReductionFactor = Math.min(0.93, gravityReductionFactor + 0.02 * level);
                AdvancementHelper.grantedIf(class_1893.field_9129, user);
            }

            // TODO
            //AttributeInstance gravity = user.getAttribute(ForgeMod.ENTITY_GRAVITY.get());
            double g = /*gravity.getValue() **/ gravityReductionFactor;

            class_243 motion = user.method_18798();
            if (motion.field_1351 < 0)
                user.method_18800(motion.field_1352, (motion.field_1351 + g) * currentRatio, motion.field_1350);
        }
    }

    public static void fallResist(class_1309 user) {
        if (!user.method_5740() && !user.method_24828()) {
            user.field_6017 = 1;

            class_243 motion = user.method_18798();
            // TODO
            //AttributeInstance gravity = user.getAttribute(ForgeMod.ENTITY_GRAVITY.get());
            double g = /*gravity.getValue()*/ 1.0;
            if (motion.field_1351 < 0)
                user.method_18800(motion.field_1352, (motion.field_1351 + g + 0.002f), motion.field_1350);
        }
    }
}
