package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class AnvilRepairEvent extends PlayerEvent {
    private final class_1799 left;
    private final class_1799 right;
    private final class_1799 output;
    private float breakChance;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onAnvilRepair(event);
        }
    });

    public AnvilRepairEvent(class_1657 player, class_1799 left, class_1799 right, class_1799 output) {
        super(player);
        this.output = output;
        this.left = left;
        this.right = right;
        this.setBreakChance(0.12f);
    }

    public class_1799 getOutput() {
        return output;
    }

    public class_1799 getLeft() {
        return left;
    }

    public class_1799 getRight() {
        return right;
    }

    public float getBreakChance() {
        return breakChance;
    }

    public void setBreakChance(float breakChance) {
        this.breakChance = breakChance;
    }

    public interface Callback {
        void onAnvilRepair(AnvilRepairEvent event);
    }
}
