package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import java.util.Collection;

public class LivingDropsEvent extends LivingEvent implements ICancellableEvent {
    private final class_1282 source;
    private final Collection<class_1542> drops;
    private final int lootingLevel;
    private final boolean recentlyHit;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onLivingDrops(event);
        }
    });

    public LivingDropsEvent(class_1309 entity, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        super(entity);
        this.source = source;
        this.drops = drops;
        this.lootingLevel = lootingLevel;
        this.recentlyHit = recentlyHit;
    }

    public class_1282 getSource() {
        return this.source;
    }

    public Collection<class_1542> getDrops() {
        return this.drops;
    }

    public int getLootingLevel() {
        return this.lootingLevel;
    }

    public boolean isRecentlyHit() {
        return this.recentlyHit;
    }

    public interface Callback {
        void onLivingDrops(LivingDropsEvent event);
    }
}
