package mods.flammpfeil.slashblade.event.bladestand;

import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import javax.annotation.Nullable;

public class CopySpecialAttackFromBladeEvent extends SlashBladeEvent {
    private final class_2960 SAKey;
    private final BladeStandAttackEvent originalEvent;
    private final class_1799 orb;
    private final class_1542 itemEntity;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onCopySpecialAttack(event);
        }
    });

    public CopySpecialAttackFromBladeEvent(class_1799 blade, ISlashBladeState state, class_2960 SAKey,
                                           BladeStandAttackEvent originalEvent,
                                           class_1799 orb, class_1542 itemEntity) {
        super(blade, state);
        this.SAKey = SAKey;
        this.originalEvent = originalEvent;
        this.orb = orb;
        this.itemEntity = itemEntity;
    }

    public CopySpecialAttackFromBladeEvent(PreCopySpecialAttackFromBladeEvent pe, class_1799 orb,
                                           class_1542 itemEntity) {
        this(pe.getBlade(), pe.getSlashBladeState(), pe.getSAKey(), pe.getOriginalEvent(), orb, itemEntity);
    }

    public class_2960 getSAKey() {
        return SAKey;
    }

    public @Nullable BladeStandAttackEvent getOriginalEvent() {
        return originalEvent;
    }

    public class_1799 getOrb() {
        return orb;
    }

    public class_1542 getItemEntity() {
        return itemEntity;
    }

    public interface Callback {
        void onCopySpecialAttack(CopySpecialAttackFromBladeEvent event);
    }
}
