package mods.flammpfeil.slashblade.event.client;

import cn.sh1rocu.slashblade.api.event.BaseEvent;
import cn.sh1rocu.slashblade.api.event.ICancellableEvent;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import java.util.function.Function;

@Environment(EnvType.CLIENT)
public class RenderOverrideEvent extends BaseEvent implements ICancellableEvent {
    class_1799 stack;
    WavefrontObject model;
    String target;
    class_2960 texture;

    class_4587 matrixStack;
    class_4597 buffer;

    WavefrontObject originalModel;
    String originalTarget;
    class_2960 originalTexture;

    int packedLightIn;
    Function<class_2960, class_1921> getRenderType;
    boolean enableEffect;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onRenderOverride(event);
        }
    });

    public class_2960 getTexture() {
        return texture;
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    public class_2960 getOriginalTexture() {
        return originalTexture;
    }

    public WavefrontObject getOriginalModel() {
        return originalModel;
    }

    public String getOriginalTarget() {
        return originalTarget;
    }

    public class_1799 getStack() {
        return stack;
    }

    public WavefrontObject getModel() {
        return model;
    }

    public void setModel(WavefrontObject model) {
        this.model = model;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public class_4587 getPoseStack() {
        return matrixStack;
    }

    public class_4597 getBuffer() {
        return buffer;
    }

    public int getPackedLightIn() {
        return packedLightIn;
    }

    public void setPackedLightIn(int packedLightIn) {
        this.packedLightIn = packedLightIn;
    }

    public Function<class_2960, class_1921> getGetRenderType() {
        return getRenderType;
    }

    public void setGetRenderType(Function<class_2960, class_1921> getRenderType) {
        this.getRenderType = getRenderType;
    }

    public boolean isEnableEffect() {
        return enableEffect;
    }

    public void setEnableEffect(boolean enableEffect) {
        this.enableEffect = enableEffect;
    }

    public interface Callback {
        void onRenderOverride(RenderOverrideEvent event);
    }

    public RenderOverrideEvent(class_1799 stack, WavefrontObject model, String target, class_2960 texture,
                               class_4587 matrixStack, class_4597 buffer, int packedLightIn, Function<class_2960, class_1921> getRenderType, boolean enableEffect) {
        this.stack = stack;
        this.originalModel = this.model = model;
        this.originalTarget = this.target = target;
        this.originalTexture = this.texture = texture;

        this.matrixStack = matrixStack;
        this.buffer = buffer;
        this.packedLightIn = packedLightIn;
        this.getRenderType = getRenderType;
        this.enableEffect = enableEffect;
    }

    public static RenderOverrideEvent onRenderOverride(class_1799 stack, WavefrontObject model, String target,
                                                       class_2960 texture, class_4587 matrixStack, class_4597 buffer, int packedLightIn, Function<class_2960, class_1921> getRenderType, boolean enableEffect) {
        RenderOverrideEvent event = new RenderOverrideEvent(stack, model, target, texture, matrixStack, buffer, packedLightIn, getRenderType, enableEffect);
        CALLBACK.invoker().onRenderOverride(event);
        return event;
    }
}
