package mods.flammpfeil.slashblade.network;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import java.util.Collection;

public class RankSyncMessage {
    public static final class_2960 ID = SlashBlade.prefix("s2c_rank_sync");

    public static void send(long rawPoint, Collection<class_3222> players) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeLong(rawPoint);
        players.forEach(player -> ServerPlayNetworking.send(player, ID, buf));
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        long rawPoint = buf.readLong();
        client.execute(() -> setPoint(rawPoint));
    }

    @Environment(EnvType.CLIENT)
    public static void setPoint(long point) {
        class_1657 pl = class_310.method_1551().field_1724;
        CapabilityConcentrationRank.RANK_POINT.maybeGet(pl).ifPresent(cr -> {

            long time = pl.method_37908().method_8510();

            IConcentrationRank.ConcentrationRanks oldRank = cr.getRank(time);

            cr.setRawRankPoint(point);
            cr.setLastUpdate(time);

            if (oldRank.level < cr.getRank(time).level)
                cr.setLastRankRise(time);
        });
    }
}