package mods.flammpfeil.slashblade.slasharts;

import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class Drive {
    public static EntityDrive doSlash(class_1309 playerIn, float roll, int lifetime, class_243 centerOffset,
                                      boolean critical, double damage, float speed) {
        return doSlash(playerIn, roll, lifetime, centerOffset, critical, damage, KnockBacks.cancel, speed);
    }

    public static EntityDrive doSlash(class_1309 playerIn, float roll, int lifetime, class_243 centerOffset,
                                      boolean critical, double damage, KnockBacks knockback, float speed) {

        int colorCode = CapabilitySlashBlade.BLADESTATE.maybeGet(playerIn.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFF3333FF);

        return doSlash(playerIn, roll, 0, lifetime, colorCode, centerOffset, critical, damage, knockback, speed);
    }

    public static EntityDrive doSlash(class_1309 playerIn, float roll, float yRot, int lifetime, int colorCode, class_243 centerOffset,
                                      boolean critical, double damage, KnockBacks knockback, float speed) {

        if (playerIn.method_37908().method_8608())
            return null;

        class_243 lookAngle = playerIn.method_5720();
        class_243 pos = playerIn.method_19538().method_1031(0.0D, (double) playerIn.method_5751() * 0.75D, 0.0D)
                .method_1019(lookAngle.method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, playerIn.method_5705(0)).method_1021(centerOffset.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, playerIn.method_5705(0) + 90).method_1021(centerOffset.field_1350))
                .method_1019(lookAngle.method_1021(centerOffset.field_1350));
        EntityDrive drive = new EntityDrive(SBEntityTypes.Drive, playerIn.method_37908());

        drive.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        drive.setDamage(damage);
        drive.setSpeed(speed);
        var resultAngle = lookAngle.method_1024(yRot);

        drive.method_7485(resultAngle.field_1352, resultAngle.field_1351, resultAngle.field_1350, drive.getSpeed(),
                0);

        drive.method_7432(playerIn);
        drive.setRotationRoll(roll);

        drive.setColor(colorCode);
        drive.setIsCritical(critical);
        drive.setKnockBack(knockback);

        drive.setLifetime(lifetime);

        if (playerIn != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(playerIn)
                    .ifPresent(rank -> drive.setRank(rank.getRankLevel(playerIn.method_37908().method_8510())));

        playerIn.method_37908().method_8649(drive);


        return drive;
    }
}
