package mods.flammpfeil.slashblade.util;

import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

import static mods.flammpfeil.slashblade.SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER;
import static mods.flammpfeil.slashblade.SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER;
import static mods.flammpfeil.slashblade.util.AttackManager.getSlashBladeDamageScale;

public class AttackHelper {
    public static boolean onPlayerAttackTarget(class_1657 player, class_1297 target) {
        if (AttackEntityCallback.EVENT.invoker().interact(
                player, player.method_37908(), class_1268.field_5808, target, null
        ) == class_1269.field_5814) {
            return false;
        } else {
            class_1799 stack = player.method_6047();
            return stack.method_7960() || (stack.method_7909() instanceof ItemSlashBladeExtension blade &&
                    !blade.onLeftClickEntity(stack, player, target));
        }
    }

    // 该方法伤害公式=(面板攻击力 + 横扫之刃附魔加成 + 评分等级加成 + 杀手类附魔加成) * 连招伤害系数 * 拔刀伤害系数 * 拔刀剑伤害调整比例 * 暴击倍率
    public static void attack(class_1309 attacker, class_1297 target, float comboRatio) {
        // 触发Forge事件，以兼容其他模组
//        if (attacker instanceof Player player && !ForgeHooks.onPlayerAttackTarget(player, target)) {
//            return;
//        }
        if (attacker instanceof class_1657 player && !onPlayerAttackTarget(player, target)) return;
        // 判断攻击目标是否可以被攻击
        if (!target.method_5732() || target.method_5698(attacker)) {
            return;
        }

        boolean isCritical = isCriticalHit(attacker, target);
        double baseDamage = calculateTotalDamage(attacker, target, comboRatio, isCritical);
        if (baseDamage <= 0.0F) {
            return;
        }

        float knockback = calculateKnockback(attacker);

        FireAspectResult fireAspectResult = handleFireAspect(attacker, target);

        class_243 originalMotion = target.method_18798();

        class_1282 damageSource;
        if (attacker instanceof class_1657 player) {
            damageSource = attacker.method_48923().method_48802(player);
        } else {
            damageSource = attacker.method_48923().method_48812(attacker);
        }

        boolean damageSuccess = target.method_5643(damageSource, (float) baseDamage);

        if (damageSuccess) {
            applyKnockback(attacker, target, knockback);
            restoreTargetMotionIfNeeded(target, originalMotion);
            playAttackEffects(attacker, target, isCritical);
            handleEnchantmentsAndDurability(attacker, target);
            handlePostAttackEffects(attacker, target, fireAspectResult);
        } else {
            handleFailedAttack(attacker, target, fireAspectResult);
        }
    }

    /**
     * 该方法伤害公式=(面板攻击力 + 横扫之刃附魔加成 + 评分等级加成 + 杀手类附魔加成) * 连招伤害系数 * 拔刀伤害系数 * 拔刀剑伤害调整比例 * 暴击倍率
     */
    public static double calculateTotalDamage(class_1309 attacker, class_1297 target, float comboRatio, boolean isCritical) {
        double baseDamage = attacker.method_26825(class_5134.field_23721);

        baseDamage += getSweepingBonus(attacker);
        baseDamage += getRankBonus(attacker);
        baseDamage += getEnchantmentBonus(attacker, target);
        baseDamage *= comboRatio * getSlashBladeDamageScale(attacker) * SLASHBLADE_DAMAGE_MULTIPLIER.get();

        if (attacker instanceof class_1657 player) {
//            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit(player, target, isCritical, isCritical ? 1.5F : 1.0F);
//            isCritical = hitResult != null;
//            if (isCritical) {
//                baseDamage *= hitResult.getDamageModifier();
//            }
            baseDamage = 1.5f;
        }
        return baseDamage;
    }


    /**
     * 横扫之刃附魔加成(三级加成3.25攻击力)
     */
    public static float getSweepingBonus(class_1309 attacker) {
        return 10 * (class_1890.method_8217(attacker) * 0.5f);
    }

    /**
     * 评分等级加成
     */
    public static float getRankBonus(class_1309 attacker) {
        IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet(attacker)
                .map(rp -> rp.getRank(attacker.method_5770().method_8510()))
                .orElse(IConcentrationRank.ConcentrationRanks.NONE);
        double rankDamageBonus = rankBonus.level / 2.0;
        if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
            int refine = CapabilitySlashBlade.BLADESTATE.maybeGet(attacker.method_6047()).map(ISlashBladeState::getRefine).orElse(0);
            int level = 0;
            if (attacker instanceof class_1657 player) {
                level = player.field_7520;
            }
            rankDamageBonus = Math.max(rankDamageBonus, Math.min(level, refine) * REFINE_DAMAGE_MULTIPLIER.get());
        }
        return (float) rankDamageBonus;
    }

    /**
     * 杀手类附魔加成(杀死类附魔攻击对应的生物加成2.5 * 附魔等级)
     */
    public static float getEnchantmentBonus(class_1309 attacker, class_1297 target) {
        if (target instanceof class_1309 living) {
            return class_1890.method_8218(attacker.method_6047(), living.method_6046());
        } else {
            return class_1890.method_8218(attacker.method_6047(), class_1310.field_6290);
        }
    }

    /**
     * 计算击退
     */
    public static float calculateKnockback(class_1309 attacker) {
        float knockback = attacker.method_5996(class_5134.field_23722) != null ? (float) attacker.method_26825(class_5134.field_23722) : 0;
        knockback += class_1890.method_8205(attacker);
        if (attacker.method_5624()) {
            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14999, attacker.method_5634(), 1.0F, 1.0F);
            ++knockback;
        }
        return knockback;
    }

    /**
     * 判断是否暴击
     */
    public static boolean isCriticalHit(class_1309 attacker, class_1297 target) {
        return attacker.field_6017 > 0.0F && !attacker.method_24828() &&
                !attacker.method_6101() && !attacker.method_5799() &&
                !attacker.method_6059(class_1294.field_5919) &&
                !attacker.method_5765() && target instanceof class_1309 && !attacker.method_5624();
    }

    /**
     * 火焰附加处理
     */
    public static class FireAspectResult {
        final float preAttackHealth;
        final boolean shouldSetFire;
        final int fireAspectLevel;

        FireAspectResult(float preAttackHealth, boolean shouldSetFire, int fireAspectLevel) {
            this.preAttackHealth = preAttackHealth;
            this.shouldSetFire = shouldSetFire;
            this.fireAspectLevel = fireAspectLevel;
        }
    }

    public static FireAspectResult handleFireAspect(class_1309 attacker, class_1297 target) {
        float preAttackHealth = 0.0F;
        boolean shouldSetFire = false;
        int fireAspectLevel = class_1890.method_8199(attacker);
        if (target instanceof class_1309 living) {
            preAttackHealth = living.method_6032();
            if (fireAspectLevel > 0 && !target.method_5809()) {
                shouldSetFire = true;
                target.method_5639(1);
            }
        }
        return new FireAspectResult(preAttackHealth, shouldSetFire, fireAspectLevel);
    }

    /**
     * 应用击退
     */
    public static void applyKnockback(class_1309 attacker, class_1297 target, float knockback) {
        if (knockback > 0) {
            if (target instanceof class_1309 living) {
                living.method_6005(knockback * 0.5D, class_3532.method_15374(attacker.method_36454() * ((float) Math.PI / 180F)), -class_3532.method_15362(attacker.method_36454() * ((float) Math.PI / 180F)));
            } else {
                target.method_5762(-class_3532.method_15374(attacker.method_36454() * ((float) Math.PI / 180F)) * knockback * 0.5D, 0.1D, class_3532.method_15362(attacker.method_36454() * ((float) Math.PI / 180F)) * knockback * 0.5D);
            }
            attacker.method_18799(attacker.method_18798().method_18805(0.6D, 1.0D, 0.6D));
            attacker.method_5728(false);
        }
    }

    /**
     * 恢复目标原有速度（用于ServerPlayer）
     */
    public static void restoreTargetMotionIfNeeded(class_1297 target, class_243 originalMotion) {
        if (target instanceof class_3222 serverPlayer && target.field_6037) {
            target.method_18799(originalMotion);
            serverPlayer.field_13987.method_14364(new class_2743(target));
            target.field_6037 = false;
        }
    }

    /**
     * 播放攻击音效与暴击效果
     */
    public static void playAttackEffects(class_1309 attacker, class_1297 target, boolean isCritical) {
        attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_15016, attacker.method_5634(), 1.0F, 1.0F);
        if (isCritical && attacker instanceof class_1657 player) {
            player.method_7277(target);
        }
    }


    /**
     * 处理附魔后置效果与耐久
     */
    public static void handleEnchantmentsAndDurability(class_1309 attacker, class_1297 target) {
        attacker.method_6114(target);
        if (target instanceof class_1309 living) {
            class_1890.method_8210(living, attacker);
        }
        class_1890.method_8213(attacker, target);

        class_1799 itemStack = attacker.method_6047();
        class_1297 entity = target;
        if (target instanceof PartEntity<?> partEntity) {
            entity = partEntity.getParent();
        }

        // 减少耐久
        if (!attacker.method_37908().method_8608() && !itemStack.method_7960() && entity instanceof class_1309 living) {
            class_1799 copy = itemStack.method_7972();
            class_1792 item = itemStack.method_7909();
            if (item.method_7873(itemStack, living, attacker) && attacker instanceof class_1657 player) {
                player.method_7259(class_3468.field_15372.method_14956(item));
            }
            if (itemStack.method_7960()) {
                if (attacker instanceof class_1657 player) {
                    // ForgeEventFactory.onPlayerDestroyItem(player, copy, InteractionHand.MAIN_HAND);
                }
                attacker.method_6122(class_1268.field_5808, class_1799.field_8037);
            }
        }
    }

    /**
     * 处理攻击后效果（统计、火焰、粒子、饱食度）
     */
    public static void handlePostAttackEffects(class_1309 attacker, class_1297 target, FireAspectResult fireAspectResult) {
        if (target instanceof class_1309) {
            float damageDealt = fireAspectResult.preAttackHealth - ((class_1309) target).method_6032();
            //伤害统计
            if (attacker instanceof class_1657 player) {
                player.method_7339(class_3468.field_15399, Math.round(damageDealt * 10.0F));
            }
            //应用完整的火焰附加效果(每级4秒)
            if (fireAspectResult.fireAspectLevel > 0) {
                target.method_5639(fireAspectResult.fireAspectLevel * 4);
            }
            // 伤害粒子
            if (attacker.method_37908() instanceof class_3218 && damageDealt > 2.0F) {
                int k = (int) (damageDealt * 0.5D);
                ((class_3218) attacker.method_37908()).method_14199(class_2398.field_11209, target.method_23317(), target.method_23323(0.5D), target.method_23321(), k, 0.1D, 0.0D, 0.1D, 0.2D);
            }
        }
        // 消耗饱食度
        if (attacker instanceof class_1657 player) {
            player.method_7322(0.1F);
        }
    }

    /**
     * 处理攻击未成功的情况
     */
    public static void handleFailedAttack(class_1309 attacker, class_1297 target, FireAspectResult fireAspectResult) {
        attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14914, attacker.method_5634(), 1.0F, 1.0F);
        if (fireAspectResult.shouldSetFire) {
            //取消预火焰附加效果
            target.method_5646();
        }
    }
}
