package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.event.PlayerTickEvent;
import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.mixin.accessor.ServerPlayerAccessor;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.world.entity.*;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class SlayerStyleArts {
    private static final class SingletonHolder {
        private static final SlayerStyleArts instance = new SlayerStyleArts();
    }

    public static SlayerStyleArts getInstance() {
        return SingletonHolder.instance;
    }

    private SlayerStyleArts() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
        PlayerTickEvent.START.register(this::onTickStart);
        PlayerTickEvent.END.register(this::onTickEnd);
    }

    final static EnumSet<InputCommand> fowerd_sprint_sneak = EnumSet.of(InputCommand.FORWARD, InputCommand.SPRINT,
            InputCommand.SNEAK);
    final static EnumSet<InputCommand> back_sprint_sneak = EnumSet.of(InputCommand.BACK, InputCommand.SPRINT,
            InputCommand.SNEAK);
    final static EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT,
            InputCommand.RIGHT);

    public static final class_2960 ADVANCEMENT_AIR_TRICK = new class_2960(SlashBlade.MODID,
            "abilities/air_trick");
    public static final class_2960 ADVANCEMENT_TRICK_DOWN = new class_2960(SlashBlade.MODID,
            "abilities/trick_down");
    public static final class_2960 ADVANCEMENT_TRICK_DODGE = new class_2960(SlashBlade.MODID,
            "abilities/trick_dodge");
    public static final class_2960 ADVANCEMENT_TRICK_UP = new class_2960(SlashBlade.MODID,
            "abilities/trick_up");

    final static int TRICKACTION_UNTOUCHABLE_TIME = 10;

    public void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();
        class_1937 worldIn = sender.method_37908();

        class_1799 stack = sender.method_6047();
        if (stack.method_7960())
            return;
        if (!(stack.method_7909() instanceof ItemSlashBlade))
            return;

        if (!old.contains(InputCommand.SPRINT)) {

            boolean isHandled = false;

            if (current.containsAll(fowerd_sprint_sneak)) {
                // air trick Or trick up
                isHandled = CapabilitySlashBlade.BLADESTATE.maybeGet(sender.method_6047()).map(state -> {
                    class_1297 tmpTarget = state.getTargetEntity(worldIn);

                    class_1297 target;

                    //if (tmpTarget != null && tmpTarget.getParts() != null && tmpTarget.getParts().length > 0) {
                    //    target = tmpTarget.getParts()[0];
                    //} else {
                    target = tmpTarget;
                    //}

                    if (target == null && 0 == ((EntityExtension) sender).sb$getPersistentData().method_10550("sb.avoid.trickup")) {
                        // trick up
                        Untouchable.setUntouchable(sender, TRICKACTION_UNTOUCHABLE_TIME);

                        class_243 motion = new class_243(0, +0.8, 0);

                        sender.method_5784(class_1313.field_6308, motion);
                        ((ServerPlayerAccessor) sender).sb$setChangingDimension(true);

                        sender.field_13987
                                .method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.75f)));

                        ((EntityExtension) sender).sb$getPersistentData().method_10569("sb.avoid.trickup", 2);
                        sender.method_24830(false);

                        ((EntityExtension) sender).sb$getPersistentData().method_10569("sb.avoid.counter", 2);
                        NBTHelper.putVector3d(((EntityExtension) sender).sb$getPersistentData(), "sb.avoid.vec", sender.method_19538());

                        AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_UP);
                        sender.method_17356(class_3417.field_14879, class_3419.field_15248, 0.5f, 1.2f);

                        return true;
                    } else if (target != null) {
                        // air trick
                        if (target == sender.method_6052()
                                && sender.field_6012 < sender.method_6083() + 100) {
                            class_1309 hitEntity = sender.method_6052();
                            if (hitEntity != null) {
                                SlayerStyleArts.doTeleport(sender, hitEntity);
                            }
                        } else {
                            EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword(
                                    SBEntityTypes.SummonedSword, worldIn) {
                                @Override
                                protected void method_7454(class_3966 entityHitResult) {
                                    super.method_7454(entityHitResult);

                                    class_1309 target = sender.method_6052();
                                    if (target != null && this.getHitEntity() == target) {
                                        SlayerStyleArts.doTeleport(sender, target);
                                    }
                                }

                                @Override
                                public void method_5773() {
                                    if (this.sb$getPersistentData().method_10577("doForceHit")) {
                                        this.doForceHitEntity(target);
                                        this.sb$getPersistentData().method_10551("doForceHit");
                                    }
                                    super.method_5773();
                                }
                            };

                            class_243 lastPos = sender.method_5836(1.0f);
                            ss.field_6038 = lastPos.field_1352;
                            ss.field_5971 = lastPos.field_1351;
                            ss.field_5989 = lastPos.field_1350;

                            class_243 targetPos = target.method_19538().method_1031(0, target.method_17682() / 2.0, 0)
                                    .method_1019(sender.method_5720().method_1021(-2.0));
                            ss.method_5814(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);

                            class_243 dir = sender.method_5720();
                            ss.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.0f, 0);

                            ss.method_7432(sender);

                            ss.setDamage(0.01f);

                            ss.setColor(state.getColorCode());

                            ss.sb$getPersistentData().method_10556("doForceHit", true);

                            worldIn.method_8649(ss);
                            sender.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F, 1.45F);

                            // ss.doForceHitEntity(target);
                        }
                        return true;
                    }

                    return false;

                }).orElse(false);
            }

            // trick down
            if (!isHandled && !sender.method_24828() && current.containsAll(back_sprint_sneak)) {
                class_243 oldpos = sender.method_19538();

                class_243 motion = new class_243(0, -5, 0);

                sender.method_5784(class_1313.field_6308, motion);
                if (sender.method_24828()) {
                    Untouchable.setUntouchable(sender, TRICKACTION_UNTOUCHABLE_TIME);

                    ((ServerPlayerAccessor) sender).sb$setChangingDimension(true);

                    sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.75f)));

                    ((EntityExtension) sender).sb$getPersistentData().method_10569("sb.avoid.counter", 2);
                    NBTHelper.putVector3d(((EntityExtension) sender).sb$getPersistentData(), "sb.avoid.vec", sender.method_19538());

                    AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DOWN);
                    sender.method_17356(class_3417.field_14879, class_3419.field_15248, 0.5f, 1.2f);

                    isHandled = true;
                } else {
                    sender.method_33574(oldpos);
                }

            }

            if (!isHandled && sender.method_24828() && current.contains(InputCommand.SPRINT)
                    && current.stream().anyMatch(move::contains)) {
                // quick avoid ground
                class_1937 level = sender.method_37908();
                int count = CapabilityMobEffect.MOB_EFFECT.maybeGet(sender)
                        .map(ef -> ef.doAvoid(level.method_8510())).orElse(0);

                if (0 < count) {
                    Untouchable.setUntouchable(sender, TRICKACTION_UNTOUCHABLE_TIME);

                    float moveForward = current.contains(InputCommand.FORWARD) == current.contains(InputCommand.BACK)
                            ? 0.0F
                            : (current.contains(InputCommand.FORWARD) ? 1.0F : -1.0F);
                    float moveStrafe = current.contains(InputCommand.LEFT) == current.contains(InputCommand.RIGHT)
                            ? 0.0F
                            : (current.contains(InputCommand.LEFT) ? 1.0F : -1.0F);
                    class_243 input = new class_243(moveStrafe, 0, moveForward);

                    sender.method_5724(3.0f, input);

                    class_243 motion = this.maybeBackOffFromEdge(sender.method_18798(), sender);

                    sender.method_17356(class_3417.field_14879, class_3419.field_15248, 0.5f, 1.2f);

                    sender.method_5784(class_1313.field_6308, motion);
                    ((ServerPlayerAccessor) sender).sb$setChangingDimension(true);

                    // sender.moveTo(sender.position());

                    sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.5f)));

                    ((EntityExtension) sender).sb$getPersistentData().method_10569("sb.avoid.counter", 2);
                    NBTHelper.putVector3d(((EntityExtension) sender).sb$getPersistentData(), "sb.avoid.vec", sender.method_19538());

                    AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DODGE);

                    CapabilitySlashBlade.BLADESTATE.maybeGet(sender.method_6047())
                            .ifPresent(state -> state.updateComboSeq(sender, state.getComboRoot()));
                }

                isHandled = true;
            }
            // slow avoid ground
            // move double tap

            /**
             * //relativeList : pos -> convertflag -> motion
             * sender.connection.setPlayerLocation(sender.getPosX(), sender.getPosY(),
             * sender.getPosZ() , sender.getYaw(1.0f), sender.getPitch(1.0f) ,
             * Sets.newHashSet(SPlayerPositionLookPacket.Flags.X,SPlayerPositionLookPacket.Flags.Z));
             */
        }

    }

    private static void doTeleport(class_1297 entityIn, class_1309 target) {
        ((EntityExtension) entityIn).sb$getPersistentData().method_10569("sb.airtrick.counter", 3);
        ((EntityExtension) entityIn).sb$getPersistentData().method_10569("sb.airtrick.target", target.method_5628());

        if (entityIn instanceof class_3222) {
            AdvancementHelper.grantCriterion((class_3222) entityIn, ADVANCEMENT_AIR_TRICK);
            class_243 motion = target.method_30950(1.0f).method_1020(entityIn.method_30950(1.0f)).method_1021(0.5f);
            ((class_3222) entityIn).field_13987.method_14364(new class_2743(entityIn.method_5628(), motion));
        }
    }

    private static void executeTeleport(class_1297 entityIn, class_1309 target) {
        if (!(entityIn.method_37908() instanceof class_3218))
            return;

        if (entityIn instanceof class_1657 player) {
            player.method_17356(class_3417.field_14879, class_3419.field_15248, 0.75F, 1.25F);

            CapabilitySlashBlade.BLADESTATE.maybeGet(player.method_6047())
                    .ifPresent(state -> state.updateComboSeq(player, state.getComboRoot()));

            Untouchable.setUntouchable(player, TRICKACTION_UNTOUCHABLE_TIME);
        }

        class_3218 worldIn = (class_3218) entityIn.method_37908();

        class_243 tereportPos = target.method_19538().method_1031(0, target.method_17682() / 2.0, 0)
                .method_1019(entityIn.method_5720().method_1021(-2.0));

        double x = tereportPos.field_1352;
        double y = tereportPos.field_1351;
        double z = tereportPos.field_1350;
        float yaw = entityIn.method_36454();
        float pitch = entityIn.method_36455();

        Set<class_2709> relativeList = Collections.emptySet();
        class_2338 blockpos = new class_2338((int) x, (int) y, (int) z);
        if (!class_1937.method_25953(blockpos)) {
            return;
        } else {
            if (entityIn instanceof class_3222 serverPlayer) {
                class_1923 chunkpos = new class_1923(blockpos);
                worldIn.method_14178().method_17297(class_3230.field_19347, chunkpos, 1, entityIn.method_5628());
                entityIn.method_5848();
                if (serverPlayer.method_6113()) {
                    serverPlayer.method_7358(true, true);
                }

                if (worldIn == entityIn.method_37908()) {
                    serverPlayer.field_13987.method_14360(x, y, z, yaw, pitch, relativeList);
                } else {
                    serverPlayer.method_14251(worldIn, x, y, z, yaw, pitch);
                }

                entityIn.method_5847(yaw);
            } else {
                float f1 = class_3532.method_15393(yaw);
                float f = class_3532.method_15393(pitch);
                f = class_3532.method_15363(f, -90.0F, 90.0F);
                if (worldIn == entityIn.method_37908()) {
                    entityIn.method_5808(x, y, z, f1, f);
                    entityIn.method_5847(f1);
                } else {
                    entityIn.method_18375();
                    class_1297 entity = entityIn;
                    entityIn = entityIn.method_5864().method_5883(worldIn);
                    if (entityIn == null) {
                        return;
                    }

                    entityIn.method_5878(entity);
                    entityIn.method_5808(x, y, z, f1, f);
                    entityIn.method_5847(f1);
                    // worldIn.addFromAnotherDimension(entityIn);
                }
            }

            if (!(entityIn instanceof class_1309) || !((class_1309) entityIn).method_6128()) {
                entityIn.method_18799(entityIn.method_18798().method_18805(1.0D, 0.0D, 1.0D));
                entityIn.method_24830(false);
            }

            if (entityIn instanceof class_1314) {
                ((class_1314) entityIn).method_5942().method_6340();
            }

        }
    }

    protected class_243 maybeBackOffFromEdge(class_243 vec, class_1309 mover) {
        double d0 = vec.field_1352;
        double d1 = vec.field_1350;

        while (d0 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(d0, (double) (-mover.method_49476()), 0.0D))) {
            if (d0 < 0.05D && d0 >= -0.05D) {
                d0 = 0.0D;
            } else if (d0 > 0.0D) {
                d0 -= 0.05D;
            } else {
                d0 += 0.05D;
            }
        }

        while (d1 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(0.0D, (double) (-mover.method_49476()), d1))) {
            if (d1 < 0.05D && d1 >= -0.05D) {
                d1 = 0.0D;
            } else if (d1 > 0.0D) {
                d1 -= 0.05D;
            } else {
                d1 += 0.05D;
            }
        }

        while (d0 != 0.0D && d1 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(d0, (double) (-mover.method_49476()), d1))) {
            if (d0 < 0.05D && d0 >= -0.05D) {
                d0 = 0.0D;
            } else if (d0 > 0.0D) {
                d0 -= 0.05D;
            } else {
                d0 += 0.05D;
            }

            if (d1 < 0.05D && d1 >= -0.05D) {
                d1 = 0.0D;
            } else if (d1 > 0.0D) {
                d1 -= 0.05D;
            } else {
                d1 += 0.05D;
            }
        }

        vec = new class_243(d0, vec.field_1351, d1);

        return vec;
    }

    static final float stepUpBoost = 1.1f;
    static final float stepUpDefault = 0.6f;

    @SuppressWarnings("deprecation")
    public void onTickStart(PlayerTickEvent.Pre event) {
        class_1657 player = event.getEntity();
        float stepUp = player.method_49476();

        class_243 deltaMovement;

        class_243 input = new class_243(player.field_6212, player.field_6227, player.field_6250);
        double scale = 1.0;
        float yRot = player.method_36454();
        double d0 = input.method_1027();
        if (d0 < 1.0E-7D) {
            deltaMovement = class_243.field_1353;
        } else {
            class_243 vec3 = (d0 > 1.0D ? input.method_1029() : input).method_1021(scale);
            float f = class_3532.method_15374(yRot * ((float) Math.PI / 180F));
            float f1 = class_3532.method_15362(yRot * ((float) Math.PI / 180F));
            deltaMovement = new class_243(vec3.field_1352 * (double) f1 - vec3.field_1350 * (double) f, vec3.field_1351,
                    vec3.field_1350 * (double) f1 + vec3.field_1352 * (double) f);
        }


        boolean doStepupBoost = true;

        if (doStepupBoost) {
            class_243 offset = deltaMovement.method_1029().method_1021(0.5f).method_1031(0, 0.25, 0);
            class_2338 offsetedPos = new class_2338(VectorHelper.f2i(player.method_19538().method_1019(offset))).method_10074();
            class_2680 blockState = player.method_37908().method_8320(offsetedPos);
            if (blockState.method_51176()) {
                doStepupBoost = false;
            }
        }

        if (doStepupBoost && (player.method_6047().method_7909() instanceof ItemSlashBlade)
                && stepUp < stepUpBoost) {
            ((EntityExtension) player).sb$getPersistentData().method_10548("sb.store.stepup", stepUp);
            player.method_49477(stepUpBoost);
        }

        // trick up cooldown
        if (player.method_24828() && 0 < ((EntityExtension) player).sb$getPersistentData().method_10550("sb.avoid.trickup")) {

            int count = ((EntityExtension) player).sb$getPersistentData().method_10550("sb.avoid.trickup");
            count--;

            if (count <= 0) {
                ((EntityExtension) player).sb$getPersistentData().method_10551("sb.avoid.trickup");

                if (player instanceof class_3222) {
                    ((class_3222) player).method_14240();
                }
            } else {
                ((EntityExtension) player).sb$getPersistentData().method_10569("sb.avoid.trickup", count);
            }
        }

        // handle avoid
        if (((EntityExtension) player).sb$getPersistentData().method_10545("sb.avoid.counter")) {
            int count = ((EntityExtension) player).sb$getPersistentData().method_10550("sb.avoid.counter");
            count--;

            if (count <= 0) {
                if (((EntityExtension) player).sb$getPersistentData().method_10545("sb.avoid.vec")) {
                    class_243 pos = NBTHelper.getVector3d(((EntityExtension) player).sb$getPersistentData(), "sb.avoid.vec");
                    player.method_29495(pos);
                }

                ((EntityExtension) player).sb$getPersistentData().method_10551("sb.avoid.counter");
                ((EntityExtension) player).sb$getPersistentData().method_10551("sb.avoid.vec");

                if (player instanceof class_3222) {
                    ((class_3222) player).method_14240();
                }
            } else {
                ((EntityExtension) player).sb$getPersistentData().method_10569("sb.avoid.counter", count);
            }
        }

        // handle AirTrick
        if (((EntityExtension) player).sb$getPersistentData().method_10545("sb.airtrick.counter")) {
            int count = ((EntityExtension) player).sb$getPersistentData().method_10550("sb.airtrick.counter");
            count--;

            if (count <= 0) {
                if (((EntityExtension) player).sb$getPersistentData().method_10545("sb.airtrick.target")) {
                    int id = ((EntityExtension) player).sb$getPersistentData().method_10550("sb.airtrick.target");

                    class_1297 target = player.method_37908().method_8469(id);
                    if (target != null && target instanceof class_1309)
                        executeTeleport(player, ((class_1309) target));
                }

                ((EntityExtension) player).sb$getPersistentData().method_10551("sb.airtrick.counter");
                ((EntityExtension) player).sb$getPersistentData().method_10551("sb.airtrick.target");
                if (player instanceof class_3222) {
                    ((class_3222) player).method_14240();
                }
            } else {
                ((EntityExtension) player).sb$getPersistentData().method_10569("sb.airtrick.counter", count);
            }
        }
    }

    public void onTickEnd(PlayerTickEvent.Post event) {
        class_1657 player = event.getEntity();
        float stepUp = ((EntityExtension) player).sb$getPersistentData().method_10583("sb.tmp.stepup");
        stepUp = Math.max(stepUp, stepUpDefault);

        if (stepUp < player.method_49476())
            player.method_49477(stepUp);
    }
}
