package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.MobSpawnEvent;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1551;
import net.minecraft.class_1590;
import net.minecraft.class_1642;
import net.minecraft.class_2378;
import net.minecraft.class_5819;

public class EntitySpawnEventHandler {
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        class_1309 entity = event.getEntity();
        boolean isZombie = isZombie(entity);
        if (!isZombie)
            return;
        if (!entity.method_6118(class_1304.field_6173).method_7960())
            return;

        class_5819 random = event.getLevel().method_8409();
        float difficultyMultiplier = event.getDifficulty().method_5458();

        class_2378<SlashBladeDefinition> bladeRegistry = SlashBlade
                .getSlashBladeDefinitionRegistry(event.getEntity().method_37908());
        if (!bladeRegistry.method_10250(SlashBladeBuiltInRegistry.SABIGATANA.method_29177()))
            return;

        float rngResult = random.method_43057();

        if (rngResult < SlashBladeConfig.BROKEN_SABIGATANA_SPAWN_CHANCE.get() * difficultyMultiplier) {
            if (rngResult < SlashBladeConfig.SABIGATANA_SPAWN_CHANCE.get() * difficultyMultiplier) {
                entity.method_5673(class_1304.field_6173,
                        bladeRegistry.method_10223(SlashBladeBuiltInRegistry.SABIGATANA.method_29177()).getBlade());
            } else {
                entity.method_5673(class_1304.field_6173,
                        bladeRegistry.method_10223(SlashBladeBuiltInRegistry.SABIGATANA_BROKEN.method_29177()).getBlade());
            }
        }
    }

    private static boolean isZombie(class_1309 entity) {
        return entity instanceof class_1642 && !(entity instanceof class_1551) && !(entity instanceof class_1590);
    }
}
