package mods.flammpfeil.slashblade.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import java.util.function.Consumer;

public class SlashBladeSmithingRecipeBuilder {
    private final class_1856 template;
    private final class_1856 base;
    private final class_1856 addition;
    private final class_7800 category;
    private final class_2960 result;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    private final class_1865<?> type;

    public SlashBladeSmithingRecipeBuilder(class_1865<?> serializer, class_1856 template, class_1856 base,
                                           class_1856 addition, class_7800 category, class_2960 result) {
        this.category = category;
        this.type = serializer;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public static SlashBladeSmithingRecipeBuilder smithing(class_1856 template, class_1856 base,
                                                           class_1856 addition, class_7800 category, class_2960 result) {
        return new SlashBladeSmithingRecipeBuilder(SlashBladeSmithingRecipe.SERIALIZER, template, base, addition,
                category, result);
    }

    public SlashBladeSmithingRecipeBuilder unlocks(String name, class_184 trigger) {
        this.advancement.method_709(name, trigger);
        return this;
    }

    public void save(Consumer<class_2444> consumer, String name) {
        this.save(consumer, new class_2960(name));
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        this.ensureValid(id);
        this.advancement.method_708(class_5797.field_39377)
                .method_709("has_the_recipe", class_2119.method_27847(id))
                .method_703(class_170.class_171.method_753(id)).method_704(class_193.field_1257);
        consumer.accept(new SlashBladeSmithingRecipeBuilder.Result(id, this.type, this.template, this.base,
                this.addition, this.result, this.advancement,
                id.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private void ensureValid(class_2960 id) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static record Result(class_2960 id, class_1865<?> type, class_1856 template, class_1856 base,
                                class_1856 addition, class_2960 result, class_161.class_162 advancement,
                                class_2960 advancementId)
            implements class_2444 {
        public void method_10416(JsonObject p_266713_) {
            p_266713_.add("template", this.template.method_8089());
            p_266713_.add("base", this.base.method_8089());
            p_266713_.add("addition", this.addition.method_8089());
            p_266713_.addProperty("blade", this.result.toString());
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.type;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }

}