package cn.sh1rocu.slashblade.mixin.common;

import cn.sh1rocu.slashblade.api.event.*;
import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 {
    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method = "causeFallDamage", at = @At(value = "RETURN", ordinal = 0))
    private void sb$onFlyableFallEvent(float fallDistance, float multiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        PlayerFlyableFallEvent.CALLBACK.invoker().onPlayerFlyableFall(new PlayerFlyableFallEvent(
                (class_1657) (Object) this, fallDistance, multiplier
        ));
    }

    @Inject(method = "hurt", at = @At("HEAD"), cancellable = true)
    public void sb$attackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingAttackEvent event = new LivingAttackEvent(this, source, amount);
        LivingAttackEvent.CALLBACK.invoker().onLivingAttack(event);
        if (event.isCanceled())
            cir.setReturnValue(false);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    public void sb$tickStartEvent(CallbackInfo ci) {
        PlayerTickEvent.START.invoker().onStart(new PlayerTickEvent.Pre((class_1657) (Object) this));
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void sb$tickEndEvent(CallbackInfo ci) {
        PlayerTickEvent.END.invoker().onEnd(new PlayerTickEvent.Post((class_1657) (Object) this));
    }

    @ModifyReturnValue(method = "createAttributes", at = @At("RETURN"))
    private static class_5132.class_5133 sb$modifyAttributes(class_5132.class_5133 original) {
        original.method_26867(ModAttributes.SLASHBLADE_DAMAGE);
        return original;
    }

    @Inject(method = "attack", at = @At("HEAD"), cancellable = true)
    public void sb$itemAttack(class_1297 targetEntity, CallbackInfo ci) {
        class_1792 item = method_6047().method_7909();
        if ((item instanceof ItemSlashBladeExtension blade)) {
            if (blade.onLeftClickEntity(method_6047(), (class_1657) (Object) this, targetEntity))
                ci.cancel();
        }
    }

    @ModifyVariable(method = "actuallyHurt", at = @At(value = "LOAD", ordinal = 0), index = 2)
    private float sb$livingHurtEvent(float value, class_1282 pDamageSource, @Share("hurt") LocalRef<LivingHurtEvent> eventRef) {
        LivingHurtEvent event = new LivingHurtEvent((class_1309) (Object) this, pDamageSource, value);
        eventRef.set(event);
        LivingHurtEvent.CALLBACK.invoker().onLivingHurt(event);
        if (event.isCanceled())
            return 0;
        return event.getAmount();
    }

    @Inject(method = "actuallyHurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"), cancellable = true)
    private void sb$shouldCancelHurt(class_1282 damageSource, float f, CallbackInfo ci, @Share("hurt") LocalRef<LivingHurtEvent> eventRef) {
        if (eventRef.get().getAmount() <= 0)
            ci.cancel();
    }

    @ModifyVariable(method = "actuallyHurt", at = @At(value = "LOAD", ordinal = 6), index = 2)
    private float sb$livingDamageEvent(float value, class_1282 pDamageSource) {
        LivingDamageEvent event = new LivingDamageEvent(this, pDamageSource, value);
        LivingDamageEvent.CALLBACK.invoker().onLivingDamage(event);
        if (event.isCanceled())
            return 0;
        return event.getAmount();
    }
}
