package mods.flammpfeil.slashblade.client.renderer.model.obj;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4588;
import java.util.ArrayList;

public class GroupObject {
    public String name;
    public ArrayList<Face> faces = new ArrayList<Face>();
    public int glDrawingMode;

    public GroupObject() {
        this("");
    }

    public GroupObject(String name) {
        this(name, -1);
    }

    public GroupObject(String name, int glDrawingMode) {
        this.name = name;
        this.glDrawingMode = glDrawingMode;
    }

    @Environment(EnvType.CLIENT)
    public void render(class_4588 tessellator) {
        if (faces.size() > 0) {
            for (Face face : faces) {
                face.addFaceForRender(tessellator);
            }
        }
    }
}