package mods.flammpfeil.slashblade.emi.mixin;

import cn.sh1rocu.slashblade.mixin.accessor.ItemStackAccessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;

import java.util.Optional;
import java.util.regex.Matcher;

@Mixin(value = ItemEmiStackSerializer.class, remap = false)
public abstract class MixinItemEmiStackSerializer implements EmiStackSerializer<ItemEmiStack> {

    @Override
    public JsonElement serialize(ItemEmiStack stack) {
        if (stack.getAmount() == 1 && stack.getChance() == 1 &&
                stack.getRemainder().isEmpty() &&
                !(stack.getItemStack().method_7909() instanceof ItemSlashBlade)) {
            String s = getType() + ":" + stack.getId();
            if (stack.hasNbt()) {
                s += stack.getNbt().method_10714();
            }
            return new JsonPrimitive(s);

        } else {
            JsonObject json = new JsonObject();
            json.addProperty("type", getType());
            json.addProperty("id", stack.getId().toString());
            if (stack.hasNbt()) {
                json.addProperty("nbt", stack.getNbt().method_10714());
            }
            if (stack.getAmount() != 1) {
                json.addProperty("amount", stack.getAmount());
            }
            if (stack.getChance() != 1) {
                json.addProperty("chance", stack.getChance());
            }
            class_1799 itemStack = stack.getItemStack();
            if (itemStack.method_7909() instanceof ItemSlashBlade) {
                var optional = CapabilitySlashBlade.BLADESTATE.maybeGet(itemStack);
                if (optional.isPresent()) {
                    json.addProperty("sbCaps", optional.orElseThrow(NullPointerException::new).getBladeState().method_10714());

                }
            }
            if (!stack.getRemainder().isEmpty()) {
                EmiStack remainder = stack.getRemainder();
                if (!remainder.getRemainder().isEmpty()) {
                    remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
                }
                if (remainder.getRemainder().isEmpty()) {
                    JsonElement remainderElement = EmiIngredientSerializer.getSerialized(remainder);
                    if (remainderElement != null) {
                        json.add("remainder", remainderElement);
                    }
                }
            }
            return json;
        }
    }

    @Override
    public EmiIngredient deserialize(JsonElement element) {
        class_2960 id = null;
        String nbt = null;
        String capNBT = null;
        long amount = 1;
        float chance = 1;
        EmiStack remainder = EmiStack.EMPTY;
        if (class_3518.method_15286(element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = EmiPort.id(m.group(2), m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            id = EmiPort.id(class_3518.method_15265(json, "id"));
            nbt = class_3518.method_15253(json, "nbt", null);
            capNBT = class_3518.method_15265(json, "sbCaps");
            amount = class_3518.method_15280(json, "amount", 1);
            chance = class_3518.method_15277(json, "chance", 1);
            if (class_3518.method_15294(json, "remainder")) {
                EmiIngredient ing = EmiIngredientSerializer.getDeserialized(json.get("remainder"));
                if (ing instanceof EmiStack stack) {
                    remainder = stack;
                }
            }
        }
        if (id != null) {
            try {
                class_2487 nbtComp = null;
                if (nbt != null) {
                    nbtComp = class_2522.method_10718(nbt);
                }
                EmiStack stack;
                if (capNBT != null) {
                    class_2487 tag = new class_2487();
                    tag.method_10566("Parent", class_2522.method_10718(capNBT));
                    class_1799 itemStack = ItemStackAccessor.sb$create(
                            EmiPort.getItemRegistry().method_10223(id),
                            (int) amount,
                            Optional.of(tag)
                    );
                    class_2487 newNbt = itemStack.method_7948();
                    if (nbtComp != null) {
                        for (String key : nbtComp.method_10541()) {
                            newNbt.method_10566(key, nbtComp.method_10580(key).method_10707());
                        }
                    }

                    stack = new ItemEmiStack(itemStack);
                } else {
                    stack = create(id, nbtComp, amount);
                }
                if (chance != 1) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }

                return stack;
            } catch (Exception e) {
                EmiLog.error("Error parsing NBT in deserialized stack", e);
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }
}