package mods.flammpfeil.slashblade.ability;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_8103;
import java.util.EnumSet;
import java.util.Optional;

public class Guard {
    private static final class SingletonHolder {
        private static final Guard instance = new Guard();
    }

    public static Guard getInstance() {
        return SingletonHolder.instance;
    }

    private Guard() {
    }

    public void register() {
        LivingAttackEvent.ATTACK.register(this::onLivingAttack);
    }

    public static final class_2960 ADVANCEMENT_GUARD = new class_2960(SlashBlade.MODID, "abilities/guard");
    public static final class_2960 ADVANCEMENT_GUARD_JUST = new class_2960(SlashBlade.MODID,
            "abilities/guard_just");

    final static EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT,
            InputCommand.RIGHT);

    public void onLivingAttack(LivingAttackEvent event) {
        class_1309 victim = event.getEntity();
        class_1282 source = event.getSource();

        // begin executable check -----------------
        // item check
        class_1799 stack = victim.method_6047();
        Optional<ISlashBladeState> slashBlade = CapabilitySlashBlade.BLADESTATE.maybeGet(stack);
        if (slashBlade.isEmpty())
            return;
        if (slashBlade.filter(ISlashBladeState::isBroken).isPresent())
            return;
        if (class_1890.method_8225(class_1893.field_9097, stack) <= 0)
            return;

        // user check
        if (!victim.method_24828())
            return;
        Optional<IInputState> input = CapabilityInputState.INPUT_STATE.maybeGet(victim);
        if (input.isEmpty())
            return;

        // commanc check
        InputCommand targetCommand = InputCommand.SNEAK;
        boolean handleCommand = input.filter(i -> i.getCommands().contains(targetCommand)
                && i.getCommands().stream().noneMatch(move::contains)).isPresent();

        if (handleCommand)
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD);

        // ninja run
        handleCommand |= (input.filter(i -> i.getCommands().contains(InputCommand.SPRINT)).isPresent()
                && victim.method_5624());

        if (!handleCommand)
            return;

        // range check
        if (!isInsideGuardableRange(source, victim))
            return;

        // performance branch -----------------
        // just check
        long timeStartPress = input.map(i -> {
            Long l = i.getLastPressTime(targetCommand);
            return l == null ? 0 : l;
        }).get();
        long timeCurrent = victim.method_37908().method_8510();

        int soulSpeedLevel = class_1890.method_8203(class_1893.field_23071, victim);
        int justAcceptancePeriod = 5 + soulSpeedLevel;

        boolean isJust = false;
        if (timeCurrent - timeStartPress < justAcceptancePeriod) {
            isJust = true;
            AdvancementHelper.grantedIf(class_1893.field_23071, victim);
        }

        // rank check
        boolean isHighRank = false;
        Optional<IConcentrationRank> rank = CapabilityConcentrationRank.RANK_POINT.maybeGet(victim);
        if (rank.filter(r -> IConcentrationRank.ConcentrationRanks.S.level <= r.getRank(timeCurrent).level).isPresent())
            isHighRank = true;

        // damage sauce check
        boolean isProjectile = source.method_48789(class_8103.field_42247)
                || source.method_5526() instanceof class_1676;

        // after executable check -----------------
        if (!isJust) {
            if (!isProjectile)
                return;
            if (!isHighRank && source.method_48789(class_8103.field_42241))
                return;

            boolean inMotion = slashBlade.filter(s -> {
                class_2960 current = s.resolvCurrentComboState(victim);
                ComboState currentCS = ComboStateRegistry.COMBO_STATE.method_10223(current);
                if (!current.equals(ComboStateRegistry.getId(ComboStateRegistry.NONE)) && current == currentCS.getNext(victim))
                    return true;
                else
                    return false;
            }).isPresent();
            if (inMotion)
                return;
        } else {
            if (!isProjectile && !(source.method_5526() instanceof class_1309))
                return;
        }

        // execute performance------------------
        // damage cancel
        event.setCanceled(true);

        // Motion
        if (isJust) {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.getId(ComboStateRegistry.COMBO_A1)));
        } else {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.getId(ComboStateRegistry.COMBO_A1_END2)));
        }

        // DirectAttack knockback
        if (!isProjectile) {
            class_1297 entity = source.method_5526();
            if (entity instanceof class_1309) {
                ((class_1309) entity).method_6005(0.5D, entity.method_23317() - victim.method_23317(), entity.method_23321() - victim.method_23321());
            }
        }

        // untouchable time
        if (isJust)
            Untouchable.setUntouchable(victim, 10);

        // rankup
        if (isJust)
            rank.ifPresent(r -> r.addRankPoint(victim.method_37908().method_48963().method_48818(victim)));

        // play sound
        if (victim instanceof class_1657) {
            victim.method_5783(class_3417.field_15104, 1.0F,
                    1.0F + victim.method_37908().method_8409().method_43057() * 0.4F);
        }

        // advancement
        if (isJust)
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD_JUST);

        // cost-------------------------
        if (!isJust && !isHighRank) {
            slashBlade.ifPresent(s -> {
                stack.method_7956(1, victim, ItemSlashBlade.getOnBroken(stack));
            });
        }

    }

    public boolean isInsideGuardableRange(class_1282 source, class_1309 victim) {
        class_243 sPos = source.method_5510();
        if (sPos != null) {
            class_243 viewVec = victim.method_5828(1.0F);
            class_243 attackVec = sPos.method_1035(victim.method_19538()).method_1029();
            attackVec = new class_243(attackVec.field_1352, 0.0D, attackVec.field_1350);
            if (attackVec.method_1026(viewVec) < 0.0D) {
                return true;
            }
        }
        return false;
    }
}
