package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.event.EntityJoinLevelEvent;
import cn.sh1rocu.slashblade.api.event.LivingTickEvent;
import cn.sh1rocu.slashblade.mixin.accessor.MobAccessor;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.mobeffect.IMobEffectState;
import mods.flammpfeil.slashblade.entity.ai.StunGoal;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_243;

/**
 * Created by Furia on 15/06/20.
 */
public class StunManager {

    static final int DEFAULT_STUN_TICKS = 10;

    public static void init() {
        EntityJoinLevelEvent.CALLBACK.register(StunManager::onEntityJoinWorldEvent);
        LivingTickEvent.CALLBACK.register(StunManager::onEntityLivingUpdate);
    }

    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof class_1314))
            return;
        class_1314 entity = (class_1314) event.getEntity();

        ((MobAccessor) entity).sb$getGoalSelector().method_6277(-1, new StunGoal(entity));
    }

    public static void onEntityLivingUpdate(LivingTickEvent event) {
        class_1309 target = event.getEntity();
        if (!(target instanceof class_1314))
            return;
        if (target.method_37908() == null)
            return;

        boolean onStun = CapabilityMobEffect.MOB_EFFECT.maybeGet(target)
                .filter((state) -> state.isStun(target.method_37908().method_8510())).isPresent();

        if (onStun) {
            class_243 motion = target.method_18798();
            if (5 < target.field_6017)
                target.method_18800(motion.field_1352, motion.field_1351 - 2.0f, motion.field_1350);
            else if (motion.field_1351 < 0)
                target.method_18800(motion.field_1352, motion.field_1351 * 0.25f, motion.field_1350);
        }

    }

    public static void setStun(class_1309 target, class_1309 attacker) {
        setStun(target);
    }

    public static void setStun(class_1309 target) {
        setStun(target, DEFAULT_STUN_TICKS);
    }

    public static void setStun(class_1309 target, long duration) {
        if (!(target instanceof class_1314))
            return;
        if (target.method_37908() == null)
            return;

        CapabilityMobEffect.MOB_EFFECT.maybeGet(target).ifPresent(state -> state.setManagedStun(target.method_37908().method_8510(), duration));
    }

    public static void removeStun(class_1309 target) {
        if (target.method_37908() == null)
            return;
        if (!(target instanceof class_1309))
            return;

        CapabilityMobEffect.MOB_EFFECT.maybeGet(target).ifPresent(IMobEffectState::clearStunTimeOut);
    }
}
