package mods.flammpfeil.slashblade.capability.concentrationrank;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.network.RankSyncMessage;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.Collections;
import java.util.Optional;

public interface IConcentrationRank extends AutoSyncedComponent {

    enum ConcentrationRanks {
        NONE(0, Range.lessThan(1.0f)), D(1, Range.closedOpen(1.0f, 2.0f)), C(2, Range.closedOpen(2.0f, 3.0f)),
        B(3, Range.closedOpen(3.0f, 4.0f)), A(4, Range.closedOpen(4.0f, 5.0f)), S(5, Range.closedOpen(5.0f, 5.25f)),
        SS(6, Range.closedOpen(5.25f, 5.5f)), SSS(7, Range.atLeast(5.5f)),
        ;

        public static float MAX_LEVEL = 6.0f;

        final Range<Float> pointRange;
        public final int level;

        ConcentrationRanks(int level, Range<Float> pointRange) {
            this.pointRange = pointRange;
            this.level = level;
        }

        public static ConcentrationRanks getRankFromLevel(float point) {
            return concentrationRanksMap.get(point);
        }

        private static RangeMap<Float, ConcentrationRanks> concentrationRanksMap = ImmutableRangeMap
                .<Float, ConcentrationRanks>builder().put(ConcentrationRanks.NONE.pointRange, ConcentrationRanks.NONE)
                .put(ConcentrationRanks.D.pointRange, ConcentrationRanks.D)
                .put(ConcentrationRanks.C.pointRange, ConcentrationRanks.C)
                .put(ConcentrationRanks.B.pointRange, ConcentrationRanks.B)
                .put(ConcentrationRanks.A.pointRange, ConcentrationRanks.A)
                .put(ConcentrationRanks.S.pointRange, ConcentrationRanks.S)
                .put(ConcentrationRanks.SS.pointRange, ConcentrationRanks.SS)
                .put(ConcentrationRanks.SSS.pointRange, ConcentrationRanks.SSS).build();
    }

    long getRawRankPoint();

    void setRawRankPoint(long point);

    long getLastUpdate();

    void setLastUpdate(long time);

    long getLastRankRise();

    void setLastRankRise(long time);

    long getUnitCapacity();

    default long getMaxCapacity() {
        return (long) (ConcentrationRanks.MAX_LEVEL * getUnitCapacity()) - 1;
    }

    default ConcentrationRanks getRank(long time) {
        return ConcentrationRanks.getRankFromLevel(getRankLevel(time));
    }

    default long reductionLimitter(long reduction) {
        long limit = getRawRankPoint() % getUnitCapacity();

        return Math.min(reduction, limit);
    }

    default float getRankLevel(long currentTime) {
        return getRankPoint(currentTime) / (float) getUnitCapacity();
    }

    default float getRankProgress(long currentTime) {
        float level = getRankLevel(currentTime);

        Range<Float> range = getRank(currentTime).pointRange;

        double bottom = range.hasLowerBound() ? range.lowerEndpoint() : 0;

        double top = range.hasUpperBound() ? range.upperEndpoint() : Math.floor(bottom + 1.0f);

        double len = top - bottom;

        return (float) ((level - bottom) / len);
    }

    default long getRankPoint(long time) {
        long reduction = time - getLastUpdate();
        return getRawRankPoint() - reductionLimitter(reduction);
    }

    default void addRankPoint(class_1309 user, long point) {
        long time = user.method_37908().method_8510();

        ConcentrationRanks oldRank = getRank(time);

        this.setRawRankPoint(Math.min(Math.max(0, point + getRankPoint(time)), getMaxCapacity()));
        this.setLastUpdate(time);

        if (oldRank.level < getRank(time).level)
            this.setLastRankRise(time);

        if (user instanceof class_3222 && !user.method_37908().method_8608()) {
            if (((class_3222) user).field_13987 == null)
                return;

            RankSyncMessage.send(this.getRawRankPoint(), Collections.singletonList((class_3222) user));
        }
    }

    default void addRankPoint(class_1282 src) {
        if (!(src.method_5529() instanceof class_1309))
            return;

        class_1309 user = (class_1309) src.method_5529();

        class_1799 stack = user.method_6047();

        Optional<class_2960> combo = CapabilitySlashBlade.BLADESTATE.maybeGet(stack)
                .map(s -> s.resolvCurrentComboState(user));

        float modifier = combo.map(this::getRankPointModifier).orElse(getRankPointModifier(src));

        addRankPoint(user, (long) (modifier * getUnitCapacity()));
    }

    float getRankPointModifier(class_1282 ds);

    float getRankPointModifier(class_2960 combo);
}
