package mods.flammpfeil.slashblade.client.renderer.model.obj;

import com.google.common.base.Suppliers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.awt.*;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class Face {
    public static boolean isSmoothShade = true;
    public static int lightmap = 15;

    public static void setLightMap(int value) {
        lightmap = value;
    }

    public static void resetLightMap() {
        lightmap = 15;
    }

    public static final BiFunction<Vector4f, Integer, Integer> alphaNoOverride = (v, a) -> a;
    public static final BiFunction<Vector4f, Integer, Integer> alphaOverrideYZZ = (v, a) -> v.y() == 0 ? 0 : a;
    public static BiFunction<Vector4f, Integer, Integer> alphaOverride = alphaNoOverride;

    public static void setAlphaOverride(BiFunction<Vector4f, Integer, Integer> alphaOverride) {
        Face.alphaOverride = alphaOverride;
    }

    public static void resetAlphaOverride() {
        Face.alphaOverride = alphaNoOverride;
    }

    public static final Vector4f uvDefaultOperator = new Vector4f(1, 1, 0, 0);
    public static Vector4f uvOperator = uvDefaultOperator;

    public static void setUvOperator(float uScale, float vScale, float uOffset, float vOffset) {
        Face.uvOperator = new Vector4f(uScale, vScale, uOffset, vOffset);
    }

    public static void resetUvOperator() {
        Face.uvOperator = uvDefaultOperator;
    }

    public static Color col;

    public static void setCol(Color col) {
        Face.col = col;
    }

    public static void resetCol() {
        Face.col = Color.white;
    }

    private static final Supplier<Matrix4f> defaultTransform = Suppliers.memoize(() -> {
        Matrix4f m = new Matrix4f();
        m.identity();
        return m;
    });

    public static class_4587 matrix = null;

    public static void setMatrix(class_4587 ms) {
        matrix = ms;
    }

    public static void resetMatrix() {
        matrix = null;
    }

    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    @Environment(EnvType.CLIENT)
    public void addFaceForRender(class_4588 tessellator) {
        addFaceForRender(tessellator, 0.0005F);
    }

    @Environment(EnvType.CLIENT)
    public void addFaceForRender(class_4588 tessellator, float textureOffset) {
        if (faceNormal == null) {
            faceNormal = this.calculateFaceNormal();
        }

        float averageU = 0F;
        float averageV = 0F;

        if ((textureCoordinates != null) && (textureCoordinates.length > 0)) {
            for (int i = 0; i < textureCoordinates.length; ++i) {
                averageU += textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
                averageV += textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            }

            averageU = averageU / textureCoordinates.length;
            averageV = averageV / textureCoordinates.length;
        }

        Matrix4f transform;
        if (matrix != null) {
            transform = matrix.method_23760().method_23761();
        } else {
            transform = defaultTransform.get();
        }

        for (int i = 0; i < vertices.length; ++i) {
            putVertex(tessellator, i, transform, textureOffset, averageU, averageV);
        }
    }

    void putVertex(class_4588 wr, int i, Matrix4f transform, float textureOffset, float averageU, float averageV) {
        float offsetU, offsetV;
        wr.method_22918(transform, vertices[i].x, vertices[i].y, vertices[i].z);

        wr.method_1336(col.getRed(), col.getGreen(), col.getBlue(),
                alphaOverride.apply(new Vector4f(vertices[i].x, vertices[i].y, vertices[i].z, 1.0F), col.getAlpha()));

        if ((textureCoordinates != null) && (textureCoordinates.length > 0)) {
            offsetU = textureOffset;
            offsetV = textureOffset;

            float textureU = textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
            float textureV = textureCoordinates[i].v * uvOperator.y() + uvOperator.w();

            if (textureU > averageU) {
                offsetU = -offsetU;
            }
            if (textureV > averageV) {
                offsetV = -offsetV;
            }

            wr.method_22913(textureU + offsetU, textureV + offsetV);
        } else {
            wr.method_22913(0, 0);
        }

        wr.method_22922(class_4608.field_21444);
        wr.method_22916(lightmap);

        Vector3f vector3f;
        if (isSmoothShade && vertexNormals != null) {

            Vertex normal = vertexNormals[i];

            vector3f = new Vector3f(normal.x, normal.y, normal.z);
        } else {
            vector3f = new Vector3f(faceNormal.x, faceNormal.y, faceNormal.z);
        }
        vector3f.mul(matrix.method_23760().method_23762());
        vector3f.normalize();
        wr.method_22914(vector3f.x(), vector3f.y(), vector3f.z());

        wr.method_1344();
    }

    public Vertex calculateFaceNormal() {
        class_243 v1 = new class_243(vertices[1].x - vertices[0].x, vertices[1].y - vertices[0].y, vertices[1].z - vertices[0].z);
        class_243 v2 = new class_243(vertices[2].x - vertices[0].x, vertices[2].y - vertices[0].y, vertices[2].z - vertices[0].z);
        class_243 normalVector = v1.method_1036(v2).method_1029();

        return new Vertex((float) normalVector.field_1352, (float) normalVector.field_1351, (float) normalVector.field_1350);
    }
}