package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3966;

public class EntityHeavyRainSwords extends EntityAbstractSummonedSword {
    private static final class_2940<Boolean> IT_FIRED = class_2945.method_12791(EntityHeavyRainSwords.class,
            class_2943.field_13323);

    public EntityHeavyRainSwords(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);

        this.setPierce((byte) 5);

        class_2487 compoundtag = this.sb$getPersistentData();
        class_2499 listtag = compoundtag.method_10554("CustomPotionEffects", 9);
        class_1293 mobeffectinstance = new class_1293(class_1294.field_5909, 20, 10);
        listtag.add(mobeffectinstance.method_5582(new class_2487()));
        this.sb$getPersistentData().method_10566("CustomPotionEffects", listtag);

    }

    @Override
    protected void method_5693() {
        super.method_5693();

        this.field_6011.method_12784(IT_FIRED, false);
    }

    public void doFire() {
        this.method_5841().method_12778(IT_FIRED, true);
    }

    public boolean itFired() {
        return this.method_5841().method_12789(IT_FIRED);
    }

    long fireTime = -1;

    @Override
    public void method_5773() {
        if (!itFired()) {
            if (method_37908().method_8608()) {
                if (method_5854() == null) {
                    method_5873(this.method_24921(), true);
                }
            }
        }

        super.method_5773();
    }

    @Override
    public void method_5842() {
        if (itFired() && fireTime <= field_6012) {
            faceEntityStandby();

            this.method_5848();

            class_243 dir = new class_243(0, -1, 0);
            this.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 4.0f, 2.0f);

            this.field_6012 = 0;

            return;
        }

        // this.startRiding()
        this.method_18799(class_243.field_1353);
        // if (canUpdate())
        this.method_5670();

        faceEntityStandby();
        // this.getVehicle().positionRider(this);

        // lifetime check
        if (!itFired()) {
            int basedelay = 10;
            fireTime = field_6012 + basedelay + getDelay();
            doFire();
        }

        /*
         * if(!level().isClientSide()) hitCheck();
         */
    }

    private void faceEntityStandby() {
        method_33574(this.method_19538());

        method_5710(this.method_36454(), -90);

    }

    public void setSpread(class_243 basePos) {
        double areaSize = 2.5;

        double offsetX = (this.field_5974.method_43058() * 2.0 - 1.0) * areaSize;
        double offsetZ = (this.field_5974.method_43058() * 2.0 - 1.0) * areaSize;

        method_5814(basePos.field_1352 + offsetX, basePos.field_1351, basePos.field_1350 + offsetZ);
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {

        class_1297 targetEntity = entityHitResult.method_17782();
        if (targetEntity instanceof class_1309) {
            KnockBacks.cancel.action.accept((class_1309) targetEntity);
            StunManager.setStun((class_1309) targetEntity);
        }

        super.method_7454(entityHitResult);
    }

    int ON_GROUND_LIFE_TIME = 20;
    int ticksInGround = 0;

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (ON_GROUND_LIFE_TIME <= this.ticksInGround) {
            this.burst();
        }

    }
}
