package mods.flammpfeil.slashblade.network;

import cn.sh1rocu.slashblade.api.extension.IEntityAdditionalSpawnData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import java.util.Objects;

public class NetworkManager {
    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver(MoveCommandMessage.ID, MoveCommandMessage::handle);
    }

    @Environment(EnvType.CLIENT)
    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver(RankSyncMessage.ID, RankSyncMessage::handle);
        ClientPlayNetworking.registerGlobalReceiver(MotionBroadcastMessage.ID, MotionBroadcastMessage::handle);
        ClientPlayNetworking.registerGlobalReceiver(IEntityAdditionalSpawnData.EXTRA_DATA_PACKET, (client, handler, buf, responseSender) -> {
            int entityId = buf.method_10816();
            buf.retain();
            client.execute(() -> {
                class_1297 entity = Objects.requireNonNull(client.field_1687).method_8469(entityId);
                if (entity instanceof IEntityAdditionalSpawnData extra) {
                    extra.readSpawnData(buf);
                }
                buf.release();
            });
        });
    }
}
