package mods.flammpfeil.slashblade.recipe;

import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8566;

public class SlashBladeShapedRecipe extends class_1869 {

    public static final class_1865<SlashBladeShapedRecipe> SERIALIZER = new SlashBladeShapedRecipeSerializer<>(
            class_1865.field_9035, SlashBladeShapedRecipe::new);

    private final class_2960 outputBlade;

    public SlashBladeShapedRecipe(class_1869 compose, class_2960 outputBlade) {
        super(compose.method_8114(), compose.method_8112(), compose.method_45441(), compose.method_8150(), compose.method_8158(),
                compose.method_8117(), getResultBlade(outputBlade));
        this.outputBlade = outputBlade;
    }

    private static class_1799 getResultBlade(class_2960 outputBlade) {
        class_1792 bladeItem = class_7923.field_41178.method_10250(outputBlade) ? class_7923.field_41178.method_10223(outputBlade)
                : SBItems.slashblade;

        return bladeItem.method_7854();
    }

    public class_2960 getOutputBlade() {
        return outputBlade;
    }

    private class_5321<SlashBladeDefinition> getOutputBladeKey() {
        return class_5321.method_29179(SlashBladeDefinition.REGISTRY_KEY, outputBlade);
    }

    @Override
    public class_1799 method_8110(class_5455 access) {
        class_1799 result = SlashBladeShapedRecipe.getResultBlade(this.getOutputBlade());

        if (!class_7923.field_41178.method_10221(result.method_7909()).equals(getOutputBlade())) {
            result = access.method_30530(SlashBladeDefinition.REGISTRY_KEY).method_31140(getOutputBladeKey())
                    .getBlade();
        }

        return result;
    }

    @Override
    public class_1799 method_17727(class_8566 container, class_5455 access) {
        var result = this.method_8110(access);
        if (!(result.method_7909() instanceof ItemSlashBlade)) {
            result = new class_1799(SBItems.slashblade);
        }

        var resultState = CapabilitySlashBlade.BLADESTATE.maybeGet(result).orElseThrow(NullPointerException::new);
        for (var stack : container.method_51305()) {
            if (!(stack.method_7909() instanceof ItemSlashBlade))
                continue;
            var ingredientState = CapabilitySlashBlade.BLADESTATE.maybeGet(stack).orElseThrow(NullPointerException::new);

            resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
            resultState.setKillCount(resultState.getKillCount() + ingredientState.getKillCount());
            resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
            updateEnchantment(result, stack);
        }

        return result;
    }

    private void updateEnchantment(class_1799 result, class_1799 ingredient) {
        var newItemEnchants = class_1890.method_8222(result);
        var oldItemEnchants = class_1890.method_8222(ingredient);
        for (class_1887 enchantIndex : oldItemEnchants.keySet()) {
            class_1887 enchantment = enchantIndex;

            int destLevel = newItemEnchants.getOrDefault(enchantIndex, 0);
            int srcLevel = oldItemEnchants.get(enchantIndex);

            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.method_8183());

            // boolean canApplyFlag = enchantment.canApplyAtEnchantingTable(result);
            boolean canApplyFlag = enchantment.method_8192(result);
            if (canApplyFlag) {
                for (class_1887 curEnchantIndex : newItemEnchants.keySet()) {
                    if (curEnchantIndex != enchantIndex
                            && !enchantment.method_8188(curEnchantIndex) /* canApplyTogether */) {
                        canApplyFlag = false;
                        break;
                    }
                }
                if (canApplyFlag)
                    newItemEnchants.put(enchantIndex, Integer.valueOf(srcLevel));
            }
        }
        class_1890.method_8214(newItemEnchants, result);
    }

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

}
