package cn.sh1rocu.slashblade.mixin.common;

import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_3222;
import net.minecraft.class_9285;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_1792 getItem();

    @Inject(method = "setDamageValue", at = @At("HEAD"), cancellable = true)
    private void sb$itemSetDamage(int damage, CallbackInfo ci) {
        if (getItem() instanceof ItemSlashBladeExtension blade) {
            blade.setDamage((class_1799) (Object) this, damage);
            ci.cancel();
        }
    }

    @ModifyVariable(method = "hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V", at = @At("HEAD"), ordinal = 0, argsOnly = true)
    private int sb$modifyBreakAmount(int amount, @Local(argsOnly = true) class_3222 entity, @Local(argsOnly = true) Consumer<class_1792> onBroken) {
        if (this.getItem() instanceof ItemSlashBladeExtension blade) {
            return blade.damageItem((class_1799) (Object) this, amount, entity, onBroken);
        }
        return amount;
    }

    @Inject(method = "getMaxDamage", at = @At("HEAD"), cancellable = true)
    private void sb$itemMaxDamage(CallbackInfoReturnable<Integer> cir) {
        if (getItem() instanceof ItemSlashBladeExtension blade) {
            cir.setReturnValue(blade.getMaxDamage((class_1799) (Object) this));
        }
    }

    @Inject(method = "getDamageValue", at = @At("HEAD"), cancellable = true)
    private void sb$itemDamage(CallbackInfoReturnable<Integer> cir) {
        if (getItem() instanceof ItemSlashBladeExtension blade) {
            cir.setReturnValue(blade.getDamage((class_1799) (Object) this));
        }
    }

    @Inject(method = "getRarity", at = @At("HEAD"), cancellable = true)
    private void sb$itemRarity(CallbackInfoReturnable<class_1814> cir) {
        if (getItem() instanceof ItemSlashBladeExtension blade) {
            cir.setReturnValue(blade.getRarity((class_1799) (Object) this));
        }
    }

    @ModifyExpressionValue(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;getOrDefault(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"
            )
    )
    private Object sb$modifyAttributeModifiers(Object original) {
        if (this.getItem() instanceof ItemSlashBladeExtension item) {
            return item.getDefaultAttributeModifiers((class_1799) (Object) this);
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/Item;getDefaultAttributeModifiers()Lnet/minecraft/world/item/component/ItemAttributeModifiers;"
            )
    )
    private class_9285 sb$modifyAttributeModifiers(class_9285 original) {
        if (this.getItem() instanceof ItemSlashBladeExtension item) {
            return item.getDefaultAttributeModifiers((class_1799) (Object) this);
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;getOrDefault(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"
            )
    )
    private Object sb$modifyAttributeModifiers_(Object original) {
        if (this.getItem() instanceof ItemSlashBladeExtension item) {
            return item.getDefaultAttributeModifiers((class_1799) (Object) this);
        }
        return original;
    }

    @ModifyExpressionValue(
            method = "forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/Item;getDefaultAttributeModifiers()Lnet/minecraft/world/item/component/ItemAttributeModifiers;"
            )
    )
    private class_9285 sb$modifyAttributeModifiers_(class_9285 original) {
        if (this.getItem() instanceof ItemSlashBladeExtension item) {
            return item.getDefaultAttributeModifiers((class_1799) (Object) this);
        }
        return original;
    }
}
