package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4051;
import java.util.EnumSet;
import java.util.List;

public class EnemyStep {
    private static final class SingletonHolder {
        private static final EnemyStep instance = new EnemyStep();
    }

    public static EnemyStep getInstance() {
        return SingletonHolder.instance;
    }

    private EnemyStep() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
    }

    static final class_4051 tc = new class_4051(false).method_36627()
            .method_18424();

    public static final class_2960 ADVANCEMENT_ENEMY_STEP = class_2960.method_60655(SlashBlade.MODID,
            "abilities/enemy_step");

    public void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();
        class_1937 worldIn = sender.method_37908();

        if (sender.method_24828())
            return;
        if (old.contains(InputCommand.JUMP))
            return;
        if (!current.contains(InputCommand.JUMP))
            return;

        List<class_1309> list = worldIn.method_18466(class_1309.class, tc, sender,
                sender.method_5829().method_1014(1));
        if (list.isEmpty())
            return;

        Untouchable.setUntouchable(sender, Untouchable.JUMP_TICKS);

        class_243 motion = new class_243(0, +0.5, 0);

        sender.method_5784(class_1313.field_6308, motion);

        sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.75f)));

        AdvancementHelper.grantCriterion(sender, ADVANCEMENT_ENEMY_STEP);
        sender.method_17356(class_3417.field_14778, class_3419.field_15248, 0.5f, 1.2f);

        CapabilitySlashBlade.getBladeState(sender.method_6047()).ifPresent(s -> {
            s.updateComboSeq(sender, ComboStateRegistry.getId(ComboStateRegistry.NONE));
        });

        if (worldIn instanceof class_3218) {
            ((class_3218) worldIn).method_14199(
                    new class_2388(class_2398.field_11217, class_2246.field_10227.method_9564()),
                    sender.method_23317(), sender.method_23318(), sender.method_23321(), 20, 0.0D, 0.0D, 0.0D, (double) 0.15F);
        }
    }

}
