package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.mixin.accessor.ServerPlayerAccessor;
import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.events.tick.PlayerTickEvent;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class SlayerStyleArts {
    private static final class_2960 STEP_HEIGHT_MOD = SlashBlade.prefix("step_height_modifier");

    private static final class SingletonHolder {

        private static final SlayerStyleArts INSTANCE = new SlayerStyleArts();
    }

    public static SlayerStyleArts getInstance() {
        return SlayerStyleArts.SingletonHolder.INSTANCE;
    }

    private SlayerStyleArts() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
        this.onTick();
    }


    final static EnumSet<InputCommand> FORWARD_SPRINT_SNEAK_COMMAND = EnumSet.of(
            InputCommand.FORWARD,
            InputCommand.SPRINT,
            InputCommand.SNEAK
    );
    final static EnumSet<InputCommand> BACK_SPRINT_SNEAK_COMMAND = EnumSet.of(
            InputCommand.BACK,
            InputCommand.SPRINT,
            InputCommand.SNEAK
    );
    final static EnumSet<InputCommand> MOVE_COMMAND = EnumSet.of(
            InputCommand.FORWARD,
            InputCommand.BACK,
            InputCommand.LEFT,
            InputCommand.RIGHT
    );

    public static final class_243 BACK_MOTION = new class_243(0, -5, 0);

    static public final class_2960 ADVANCEMENT_AIR_TRICK = SlashBlade.prefix("abilities/air_trick");
    static public final class_2960 ADVANCEMENT_TRICK_DOWN = SlashBlade.prefix("abilities/trick_down");
    static public final class_2960 ADVANCEMENT_TRICK_DODGE = SlashBlade.prefix("abilities/trick_dodge");
    static public final class_2960 ADVANCEMENT_TRICK_UP = SlashBlade.prefix("abilities/trick_up");

    public static final String AVOID_TRICKUP_PATH = "sb.avoid.trickup";
    public static final String AVOID_COUNTER_PATH = "sb.avoid.counter";
    public static final String AVOID_VEC_PATH = "sb.avoid.vec";
    public static final String AIRTRICK_COUNTER_PATH = "sb.airtrick.counter";
    public static final String AIRTRICK_TARGET_PATH = "sb.airtrick.target";

    public static final String STORE_STEPUP_PATH = "sb.store.stepup";
    public static final String TMP_STEPUP_PATH = "sb.tmp.stepup";
    public static final String DO_FORCE_HIT_PATH = "doForceHit";

    public final static int TRICK_ACTION_UNTOUCHABLE_TIME = 10;

    public void onInputChange(InputCommandEvent event) {
        class_3222 sender = event.getEntity();
        class_1799 stack = sender.method_6047();

        if (stack.method_7960()) return;
        if (!(stack.method_7909() instanceof ItemSlashBlade)) return;

        class_3218 worldIn = sender.method_51469();
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();

        if (!old.contains(InputCommand.SPRINT)) {
            processInputCommands(sender, worldIn, current);

        }
    }

    public void processInputCommands(class_3222 sender, class_1937 worldIn, EnumSet<InputCommand> current) {
        boolean isHandled = false;

        if (current.containsAll(FORWARD_SPRINT_SNEAK_COMMAND)) {
            isHandled = handleForwardSprintSneak(sender, worldIn);

        }

        if (!isHandled && !sender.method_24828() &&
                current.containsAll(BACK_SPRINT_SNEAK_COMMAND)) {
            isHandled = handleBackSprintSneak(sender);

        }

        if (!isHandled && sender.method_24828() &&
                current.contains(InputCommand.SPRINT)
                && current.stream().anyMatch(MOVE_COMMAND::contains)) {
            isHandled = handleSprintMove(sender, current);

        }
    }

    public boolean handleForwardSprintSneak(class_3222 sender, class_1937 worldIn) {
        return CapabilitySlashBlade.getBladeState(sender.method_6047()).map(state -> {
            class_1297 tmpTarget = state.getTargetEntity(worldIn);
            class_1297 target = (tmpTarget instanceof MultiPartEntity mp && mp.getParts() != null && mp.getParts().length > 0)
                    ? mp.getParts()[0] : tmpTarget;

            if (target == null
                    && ((EntityExtension) sender).sb$getPersistentData().method_10550(AVOID_TRICKUP_PATH) == 0) {
                return executeTrickUp(sender);
            } else if (target != null) {
                return executeAirTrick(sender, worldIn, target, state);
            }

            return false;
        }).orElse(false);
    }

    public boolean handleBackSprintSneak(class_3222 sender) {
        class_243 oldPos = sender.method_19538();

        sender.method_5784(class_1313.field_6308, BACK_MOTION);
        if (sender.method_24828()) {
            applyFullTrickEffects(sender, BACK_MOTION, AVOID_COUNTER_PATH, ADVANCEMENT_TRICK_DOWN, 0.75f);

            return true;
        } else {
            sender.method_33574(oldPos);

            return false;
        }
    }

    public boolean handleSprintMove(class_3222 sender, EnumSet<InputCommand> current) {
        class_3218 level = sender.method_51469();
        int count = CapabilityMobEffect.MOB_EFFECT.maybeGet(sender)
                .map(effect -> effect.doAvoid(level.method_8510()))
                .orElse(0);

        if (count > 0) {
            applyBasicTrickEffects(sender);

            class_243 input = getInput(current);
            sender.method_5724(3.0f, input);
            class_243 motion = this.maybeBackOffFromEdge(sender.method_18798(), sender);

            sender.method_17356(class_3417.field_14879, class_3419.field_15248, 0.5f, 1.2f);
            sender.method_5784(class_1313.field_6308, motion);
            sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.5f)));

            applyTrickMotionAndData(sender, motion, AVOID_COUNTER_PATH, sender.method_19538());
            AdvancementHelper.grantCriterion(sender, ADVANCEMENT_TRICK_DODGE);

            CapabilitySlashBlade.getBladeState(sender.method_6047())
                    .ifPresent(state -> state.updateComboSeq(sender, state.getComboRoot()));

        }

        return true;
    }

    public static @NotNull class_243 getInput(EnumSet<InputCommand> current) {
        float moveForward = current.contains(InputCommand.FORWARD) ^ current.contains(InputCommand.BACK)
                ?
                (current.contains(InputCommand.FORWARD) ?
                        1.0F :
                        -1.0F) :
                0.0F;

        float moveStrafe = current.contains(InputCommand.LEFT) ^ current.contains(InputCommand.RIGHT)
                ?
                (current.contains(InputCommand.LEFT) ?
                        1.0F :
                        -1.0F) :
                0.0F;

        return new class_243(moveStrafe, 0, moveForward);
    }

    public void applyBasicTrickEffects(class_3222 sender) {
        Untouchable.setUntouchable(sender, TRICK_ACTION_UNTOUCHABLE_TIME);
        ((ServerPlayerAccessor) sender).sb$setChangingDimension(true);

    }

    public void applyTrickMotionAndData(class_3222 sender, class_243 motion, String counterPath, class_243 position) {
        sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(0.75f)));
        ((EntityExtension) sender).sb$getPersistentData().method_10569(counterPath, 2);
        NBTHelper.putVector3d(((EntityExtension) sender).sb$getPersistentData(), AVOID_VEC_PATH, position);

    }

    public void applyTrickSoundAndAdvancement(class_3222 sender, class_2960 advancement) {
        AdvancementHelper.grantCriterion(sender, advancement);
        sender.method_17356(class_3417.field_14879, class_3419.field_15248, 0.5f, 1.2f);

    }

    public void applyFullTrickEffects(class_3222 sender, class_243 motion, String counterPath,
                                      class_2960 advancement, float motionScale) {
        applyBasicTrickEffects(sender);
        sender.field_13987.method_14364(new class_2743(sender.method_5628(), motion.method_1021(motionScale)));
        ((EntityExtension) sender).sb$getPersistentData().method_10569(counterPath, 2);
        NBTHelper.putVector3d(((EntityExtension) sender).sb$getPersistentData(), AVOID_VEC_PATH, sender.method_19538());
        applyTrickSoundAndAdvancement(sender, advancement);

    }

    public boolean executeTrickUp(class_3222 sender) {
        class_243 motion = new class_243(0, +0.8, 0);
        sender.method_5784(class_1313.field_6308, motion);

        applyFullTrickEffects(sender, motion, AVOID_TRICKUP_PATH, ADVANCEMENT_TRICK_UP, 0.75f);
        ((EntityExtension) sender).sb$getPersistentData().method_10569(AVOID_COUNTER_PATH, 2);
        sender.method_24830(false);

        return true;
    }

    public boolean executeAirTrick(class_3222 sender, class_1937 worldIn, class_1297 target, ISlashBladeState state) {
        if (target == sender.method_6052() && sender.field_6012 < sender.method_6083() + 100) {
            class_1309 hitEntity = sender.method_6052();
            if (hitEntity != null) {
                SlayerStyleArts.doTeleport(sender, hitEntity);

            }
        } else {
            createSummonedSwordForAirTrick(sender, worldIn, target, state);

        }
        return true;
    }

    public void createSummonedSwordForAirTrick(class_3222 sender, class_1937 worldIn, class_1297 target, ISlashBladeState state) {
        EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword(
                SBEntityTypes.SummonedSword, worldIn) {

            @Override
            protected void method_7454(class_3966 entityHitResult) {
                super.method_7454(entityHitResult);
                class_1309 hitTarget = sender.method_6052();
                if (hitTarget != null && this.getHitEntity() == hitTarget) {
                    SlayerStyleArts.doTeleport(sender, hitTarget);

                }
            }

            @Override
            public void method_5773() {
                if (this.sb$getPersistentData().method_10577(DO_FORCE_HIT_PATH)) {
                    this.doForceHitEntity(target);
                    this.sb$getPersistentData().method_10551(DO_FORCE_HIT_PATH);

                }
                super.method_5773();
            }
        };

        class_243 lastPos = sender.method_5836(1.0f);
        ss.field_6038 = lastPos.field_1352;
        ss.field_5971 = lastPos.field_1351;
        ss.field_5989 = lastPos.field_1350;

        class_243 targetPos = target.method_19538().method_1031(0, target.method_17682() / 2.0, 0)
                .method_1019(sender.method_5720().method_1021(-2.0));
        ss.method_5814(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);

        class_243 dir = sender.method_5720();
        ss.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.0f, 0);
        ss.method_7432(sender);
        ss.setDamage(0.01f);
        ss.setColor(state.getColorCode());
        ss.sb$getPersistentData().method_10556(DO_FORCE_HIT_PATH, true);

        worldIn.method_8649(ss);
        sender.method_17356(class_3417.field_14890, class_3419.field_15248, 0.2F, 1.45F);

    }

    public static void doTeleport(class_1297 entityIn, class_1309 target) {
        ((EntityExtension) entityIn).sb$getPersistentData().method_10569(AIRTRICK_COUNTER_PATH, 3);
        ((EntityExtension) entityIn).sb$getPersistentData().method_10569(AIRTRICK_TARGET_PATH, target.method_5628());

        if (entityIn instanceof class_3222 serverPlayer) {
            AdvancementHelper.grantCriterion(serverPlayer, ADVANCEMENT_AIR_TRICK);
            class_243 motion = target.method_30950(1.0f).method_1020(entityIn.method_30950(1.0f)).method_1021(0.5f);
            serverPlayer.field_13987.method_14364(new class_2743(entityIn.method_5628(), motion));

        }
    }

    public static void executeTeleport(class_1297 entityIn, class_1309 target) {
        if (!(entityIn.method_37908() instanceof class_3218 serverLevel)) return;

        prepareTeleportEffects(entityIn);
        class_243 teleportPos = calculateTeleportPosition(entityIn, target);

        if (!isValidTeleportPosition(teleportPos)) {
            return;
        }

        performTeleportation(entityIn, serverLevel, teleportPos);
        applyPostTeleportEffects(entityIn);

    }

    public static void prepareTeleportEffects(class_1297 entityIn) {
        if (entityIn instanceof class_3222 serverPlayer) {
            serverPlayer.method_17356(class_3417.field_14879, class_3419.field_15248, 0.75F, 1.25F);
            CapabilitySlashBlade.getBladeState(serverPlayer.method_6047())
                    .ifPresent(state -> state.updateComboSeq(serverPlayer, state.getComboRoot()));
            Untouchable.setUntouchable(serverPlayer, TRICK_ACTION_UNTOUCHABLE_TIME);
        }
    }

    public static class_243 calculateTeleportPosition(class_1297 entityIn, class_1309 target) {
        return target.method_19538()
                .method_1031(0, target.method_17682() / 2.0, 0)
                .method_1019(entityIn.method_5720().method_1021(-2.0));
    }

    public static boolean isValidTeleportPosition(class_243 teleportPos) {
        class_2338 blockPos = new class_2338((int) teleportPos.field_1352, (int) teleportPos.field_1351, (int) teleportPos.field_1350);
        return class_1937.method_25953(blockPos);
    }

    public static void performTeleportation(class_1297 entityIn, class_3218 serverLevel, class_243 teleportPos) {
        double x = teleportPos.field_1352;
        double y = teleportPos.field_1351;
        double z = teleportPos.field_1350;
        float yaw = entityIn.method_36454();
        float pitch = entityIn.method_36455();

        if (entityIn instanceof class_3222 serverPlayer) {
            handleServerPlayerTeleportation(serverPlayer, serverLevel, x, y, z, yaw, pitch);
        } else {
            handleEntityTeleportation(entityIn, serverLevel, x, y, z, yaw, pitch);
        }
    }

    public static void handleServerPlayerTeleportation(class_3222 serverPlayer, class_3218 serverLevel,
                                                       double x, double y, double z, float yaw, float pitch) {
        Set<class_2709> relativeList = Collections.emptySet();
        class_2338 blockPos = new class_2338((int) x, (int) y, (int) z);
        class_1923 chunkPos = new class_1923(blockPos);

        serverLevel.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, serverPlayer.method_5628());
        serverPlayer.method_5848();

        if (serverPlayer.method_6113()) {
            serverPlayer.method_7358(true, true);

        }

        if (serverLevel == serverPlayer.method_37908()) {
            serverPlayer.field_13987.method_14360(x, y, z, yaw, pitch, relativeList);

        } else {
            serverPlayer.method_14251(serverLevel, x, y, z, yaw, pitch);

        }
        serverPlayer.method_5847(yaw);

    }

    public static void handleEntityTeleportation(class_1297 entityIn, class_3218 serverLevel,
                                                 double x, double y, double z, float yaw, float pitch) {
        float wrappedYaw = class_3532.method_15393(yaw);
        float clampedPitch = class_3532.method_15363(class_3532.method_15393(pitch), -90.0F, 90.0F);

        if (serverLevel == entityIn.method_37908()) {
            entityIn.method_5808(x, y, z, wrappedYaw, clampedPitch);
            entityIn.method_5847(wrappedYaw);
        } else {
            handleCrossDimensionTeleport(entityIn, serverLevel, x, y, z, wrappedYaw, clampedPitch);
        }
    }

    public static void handleCrossDimensionTeleport(class_1297 entityIn, class_3218 serverLevel,
                                                    double x, double y, double z, float yaw, float pitch) {
        entityIn.method_18375();
        class_1297 newEntity = entityIn.method_5864().method_5883(serverLevel);

        if (newEntity != null) {
            newEntity.method_5878(entityIn);
            newEntity.method_5808(x, y, z, yaw, pitch);
            newEntity.method_5847(yaw);
        }
    }

    public static void applyPostTeleportEffects(class_1297 entityIn) {
        if (!(entityIn instanceof class_1309) || !((class_1309) entityIn).method_6128()) {
            entityIn.method_18799(entityIn.method_18798().method_18805(1.0D, 0.0D, 1.0D));
            entityIn.method_24830(false);
        }

        if (entityIn instanceof class_1314 pathfinderMob) {
            pathfinderMob.method_5942().method_6340();
        }
    }

    protected class_243 maybeBackOffFromEdge(class_243 vec, class_1309 mover) {
        double d0 = vec.field_1352;
        double d1 = vec.field_1350;

        while (d0 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(d0, -mover.method_49476(), 0.0D))) {
            if (d0 < 0.05D && d0 >= -0.05D) {
                d0 = 0.0D;
            } else if (d0 > 0.0D) {
                d0 -= 0.05D;
            } else {
                d0 += 0.05D;
            }
        }

        while (d1 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(0.0D, -mover.method_49476(), d1))) {
            if (d1 < 0.05D && d1 >= -0.05D) {
                d1 = 0.0D;
            } else if (d1 > 0.0D) {
                d1 -= 0.05D;
            } else {
                d1 += 0.05D;
            }
        }

        while (d0 != 0.0D && d1 != 0.0D && mover.method_37908().method_8587(mover,
                mover.method_5829().method_989(d0, -mover.method_49476(), d1))) {
            if (d0 < 0.05D && d0 >= -0.05D) {
                d0 = 0.0D;
            } else if (d0 > 0.0D) {
                d0 -= 0.05D;
            } else {
                d0 += 0.05D;
            }

            if (d1 < 0.05D && d1 >= -0.05D) {
                d1 = 0.0D;
            } else if (d1 > 0.0D) {
                d1 -= 0.05D;
            } else {
                d1 += 0.05D;
            }
        }

        vec = new class_243(d0, vec.field_1351, d1);

        return vec;
    }

    static final float stepUpBoost = 1.1f;
    static final float stepUpDefault = 0.6f;

    public void onTick() {
        PlayerTickEvent.Pre.EVENT.register(this::handleTickStart);
        PlayerTickEvent.Post.EVENT.register(this::handleTickEnd);
    }

    public void handleTickStart(PlayerTickEvent.Pre event) {
        var player = event.getEntity();
        handleStepUpBoost(player);
        handleTrickUpCooldown(player);
        handleAvoidCounter(player);
        handleAirTrickCounter(player);

    }

    public void handleStepUpBoost(class_1657 player) {
        float stepUp = player.method_49476();
        boolean doStepupBoost = shouldApplyStepUpBoost(player);

        if (doStepupBoost && (player.method_6047().method_7909() instanceof ItemSlashBlade)
                && stepUp < stepUpBoost) {
            ((EntityExtension) player).sb$getPersistentData().method_10548(STORE_STEPUP_PATH, stepUp);
            class_1324 attribute = player.method_5996(class_5134.field_47761);
            if (attribute != null) {
                class_1322 modifier = new class_1322(STEP_HEIGHT_MOD, stepUpBoost - stepUp, class_1322.class_1323.field_6328);
                attribute.method_55696(modifier);
            }
        }
    }


    public boolean shouldApplyStepUpBoost(class_1657 player) {
        class_243 deltaMovement = calculatePlayerMovement(player);

        if (deltaMovement.equals(class_243.field_1353)) {
            return false;
        }

        class_243 offset = deltaMovement.method_1029().method_1021(0.5f).method_1031(0, 0.25, 0);
        class_2338 offsetPos = new class_2338(VectorHelper.f2i(player.method_19538().method_1019(offset))).method_10074();
        class_2680 blockState = player.method_37908().method_8320(offsetPos);
        @SuppressWarnings("deprecation")
        var liquid = !blockState.method_51176();
        return liquid;
    }

    public class_243 calculatePlayerMovement(class_1657 player) {
        class_243 input = new class_243(player.field_6212, player.field_6227, player.field_6250);
        double scale = 1.0;
        float yRot = player.method_36454();
        double d0 = input.method_1027();

        if (d0 < 1.0E-7D) {
            return class_243.field_1353;
        }

        class_243 vec3 = (d0 > 1.0D ? input.method_1029() : input).method_1021(scale);
        float f = class_3532.method_15374(yRot * ((float) Math.PI / 180F));
        float f1 = class_3532.method_15362(yRot * ((float) Math.PI / 180F));

        return new class_243(vec3.field_1352 * f1 - vec3.field_1350 * f, vec3.field_1351, vec3.field_1350 * f1 + vec3.field_1352 * f);
    }

    public void handleTrickUpCooldown(class_1657 player) {
        if (!player.method_24828() || !((EntityExtension) player).sb$getPersistentData().method_10545(AVOID_TRICKUP_PATH)) {
            return;
        }

        int count = ((EntityExtension) player).sb$getPersistentData().method_10550(AVOID_TRICKUP_PATH) - 1;

        if (count <= 0) {
            ((EntityExtension) player).sb$getPersistentData().method_10551(AVOID_TRICKUP_PATH);
            triggerDimensionChange(player);
        } else {
            ((EntityExtension) player).sb$getPersistentData().method_10569(AVOID_TRICKUP_PATH, count);
        }
    }

    public void handleAvoidCounter(class_1657 player) {
        if (!((EntityExtension) player).sb$getPersistentData().method_10545(AVOID_COUNTER_PATH)) {
            return;
        }

        int count = ((EntityExtension) player).sb$getPersistentData().method_10550(AVOID_COUNTER_PATH) - 1;

        if (count <= 0) {
            restoreAvoidPosition(player);
            clearAvoidData(player);
            triggerDimensionChange(player);

        } else {
            ((EntityExtension) player).sb$getPersistentData().method_10569(AVOID_COUNTER_PATH, count);

        }
    }

    public void restoreAvoidPosition(class_1657 player) {
        if (((EntityExtension) player).sb$getPersistentData().method_10545(AVOID_VEC_PATH)) {
            class_243 pos = NBTHelper.getVector3d(((EntityExtension) player).sb$getPersistentData(), AVOID_VEC_PATH);
            player.method_29495(pos);

        }
    }

    public void clearAvoidData(class_1657 player) {
        ((EntityExtension) player).sb$getPersistentData().method_10551(AVOID_COUNTER_PATH);
        ((EntityExtension) player).sb$getPersistentData().method_10551(AVOID_VEC_PATH);

    }

    public void handleAirTrickCounter(class_1657 player) {
        if (!((EntityExtension) player).sb$getPersistentData().method_10545(AIRTRICK_COUNTER_PATH)) {
            return;
        }

        int count = ((EntityExtension) player).sb$getPersistentData().method_10550(AIRTRICK_COUNTER_PATH) - 1;

        if (count <= 0) {
            executeAirTrickTeleport(player);
            clearAirTrickData(player);
            triggerDimensionChange(player);

        } else {
            ((EntityExtension) player).sb$getPersistentData().method_10569(AIRTRICK_COUNTER_PATH, count);

        }
    }

    public void executeAirTrickTeleport(class_1657 player) {
        if (!((EntityExtension) player).sb$getPersistentData().method_10545(AIRTRICK_TARGET_PATH)) {
            return;
        }

        int id = ((EntityExtension) player).sb$getPersistentData().method_10550(AIRTRICK_TARGET_PATH);
        class_1297 target = player.method_37908().method_8469(id);

        if (target instanceof class_1309 livingEntity) {
            executeTeleport(player, livingEntity);

        }
    }

    public void clearAirTrickData(class_1657 player) {
        ((EntityExtension) player).sb$getPersistentData().method_10551(AIRTRICK_COUNTER_PATH);
        ((EntityExtension) player).sb$getPersistentData().method_10551(AIRTRICK_TARGET_PATH);

    }

    public void triggerDimensionChange(class_1657 player) {
        if (player instanceof class_3222 serverPlayer) {
            serverPlayer.method_14240();

        }
    }

    public void handleTickEnd(PlayerTickEvent.Post event) {
        var player = event.getEntity();
        float stepUp = ((EntityExtension) player).sb$getPersistentData().method_10583(TMP_STEPUP_PATH);
        stepUp = Math.max(stepUp, stepUpDefault);

        if (stepUp < player.method_49476()) {
            class_1324 attribute = player.method_5996(class_5134.field_47761);
            if (attribute != null) {
                class_1322 modifier = new class_1322(STEP_HEIGHT_MOD, stepUp - player.method_49476(), class_1322.class_1323.field_6328);
                attribute.method_55696(modifier);
            }
        }
    }

}