package mods.flammpfeil.slashblade.capability.concentrationrank;

import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.class_1282;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ConcentrationRank implements IConcentrationRank {

    long rankpoint;
    long lastupdate;
    long lastrankrise;

    public static long UnitCapacity = 300;

    public ConcentrationRank() {
        rankpoint = 0;
        lastupdate = 0;
    }

    @Override
    public long getRawRankPoint() {
        return rankpoint;
    }

    @Override
    public void setRawRankPoint(long point) {
        this.rankpoint = point;
    }

    @Override
    public long getLastUpdate() {
        return lastupdate;
    }

    @Override
    public void setLastUpdate(long time) {
        this.lastupdate = time;
    }

    @Override
    public long getLastRankRise() {
        return this.lastrankrise;
    }

    @Override
    public void setLastRankRise(long time) {
        this.lastrankrise = time;
    }

    @Override
    public long getUnitCapacity() {
        return UnitCapacity;
    }

    @Override
    public float getRankPointModifier(class_1282 ds) {
        return 0.1f;
    }

    @Override
    public float getRankPointModifier(class_2960 combo) {
        return 0.1f;
    }

    @Override
    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 provider) {
        NBTHelper.getNBTCoupler(tag)
                .get("rawPoint", this::setRawRankPoint).get("lastupdate", this::setLastUpdate);
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 provider) {
        NBTHelper.getNBTCoupler(tag).put("rawPoint", getRawRankPoint()).put("lastupdate", getLastUpdate());
    }
}
